<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Fileuploadadmin extends CI_Controller 
{
	var $service="swamijifiles";
	var $currentUser='';
    function __construct() 
    {
        parent::__construct();
		if($this->session->userdata('id'))
		{
			$this->currentUser=$this->session->userdata("admin_data");
		}
		$this->load->model("swamijifiles/user_files_model");
    }
    public function index() 
	{
        $data = array('views'=>array("swamijifiles/admin/list"));
        $this->load->view(ADMIN_TEMPLATE,$data);
    }

    public function listc($excel=0)
	{
		$list=$this->user_files_model->listAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Swamiji files listing ajax request");
	}

	public function files($userId=0) 
	{
		if(is_numeric($userId) && $userId)
		{
			$this->load->model("user/users_model");
			$userData=$this->users_model->userData($userId);
			if(empty($userData))
			{
				redirect("fileuploadadmin");
			}
	        $data = array('views'=>array("swamijifiles/admin/list_files"));
	        $data['userData']=$userData;
	        $this->load->view(ADMIN_TEMPLATE,$data);
	    }
	    else
	    {
	    	redirect("fileuploadadmin");
	    }
    }

    public function listf($userId=0,$excel=0)
	{
		if(is_numeric($userId) && $userId)
		{
			$this->load->model("user/users_model");
			$userData=$this->users_model->userData($userId);
			if(empty($userData))
			{
				return;
			}
	        $list=$this->user_files_model->listFiles($userData,$excel);
			echo json_encode($list);
			$this->logaction->log($this->service,"Admin - Swamiji files listing by user ajax request - User ID:".$userId);
	    }
			
	}

	public function download($fileId=0)
	{
		$flag=0;
		if(is_numeric($fileId) && $fileId)
		{
			$fileData=$this->user_files_model->attachmentData($fileId);
			if(empty($fileData))
			{
				goto end;
			}
			
			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
			
			$amazonUri="private_files/user_swamiji_files/".$fileData->user_id."/".$fileData->filename;
			header("Cache-Control: public");
	        header("Content-Disposition: attachment; filename=".$fileData->filename);
			$obj=$this->s3->getObject(aws_s3_bucket_name,$amazonUri);
			echo $obj->body;
			return;
		}
		end:
		if($flag==0)
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}
	function delete($attachmentId=0)
	{
		$data['flag']=0;
		if(is_numeric($attachmentId) && $attachmentId)
		{
			$attachmentData=$this->user_files_model->attachmentData($attachmentId);
			if(!empty($attachmentData))
			{
				$r=$this->user_files_model->delete($attachmentData);
				if($r)
				{
					$data['flag']=1;
					$data['filename']=$attachmentData->filename;
				}
			}
		}
		echo json_encode($data);
	}
}
?>