<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Downloadsadmin extends CI_Controller 
{
	var $currentUser='';
	var $service='content';
    function __construct() 
	{
        parent::__construct();
		if($this->session->userdata('id'))
		{
			$this->currentUser=$this->session->userdata("admin_data");
		}
		$this->load->model("content/downloads_model");
		$this->load->model("content/downloads_categories_model");
		if(is_single_ashram_site)
        { 
            $this->session->set_userdata("ashramId",default_ashram_id); 
		}
    }
    function index()
	{
		$views = array('downloads/admin/list');
		$data = array('views'=>$views);
		$data['download_cats'] = $this->downloads_categories_model->getList();
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
	}
	public function listc($excel=0)
	{
		$ashramId = $this->session->userdata("ashramId");
		if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
		{
			if($this->currentUser->ashram_id)
				$ashramId=$this->currentUser->ashram_id;
			else if($this->currentUser->satsang_id)
				$ashramId=$this->currentUser->satsang_id;
		}
		$ashramId = isset($ashramId)?$ashramId:0;
		$list=$this->downloads_model->listAdmin($ashramId,$excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Downloads listing ajax request");
	}

	public function categories()
	{
		$views = array( 'downloads/admin/list_downloads_categories');
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function listcats($excel=0)
	{
		$list=$this->downloads_categories_model->listAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Downloads categories listing ajax request");
	}

	public function add_edit_category($id=0)
	{
		if($id)
		{
			$categoryData=$this->downloads_categories_model->categoryData($id);
			if(empty($categoryData))
			{
				$this->session->set_flashdata("cat_error",1);
				redirect("/downloadsadmin/categories");
			}
		}
		else
			$categoryData=array();

		if(isset($_POST["add_category"]))
		{
			$this->form_validation->set_rules('name', 'Category name', 'trim|required|min_length[3]|max_length[200]|check_downloads_category['.$id.']');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("cat_error",1);
				redirect('downloadsadmin/add_edit_category/'.$id);
				return;
			}
			
			$saved=$this->downloads_categories_model->save($id,$categoryData);

			if($saved)
			{
				if($id)
						$this->session->set_flashdata("cat_saved",1);
				else
				{
					$this->session->set_flashdata("cat_created",1);
				}
			}
			redirect('downloadsadmin/add_edit_category/'.$saved);
		}
		else
		{	
		 	$views = array( 'downloads/admin/add_edit_downloads_category' );
		 	$data = array('views'=>$views,'id'=>$id);
			if($id)
			{
				$data['categoryData']=$categoryData;
			}
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}

	function delete_category($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$categoryData=$this->downloads_categories_model->categoryData($id);
			if(empty($categoryData))
			{
				goto end;
			}
			if($categoryData->in_use>0)
			{
				$data['flag']=2;
				$data['name']=$categoryData->name;
				goto end;
			}
			$r=$this->downloads_categories_model->delete($id,$categoryData);
			if($r)
			{
				$data['flag']=1;
				$data['name']=$categoryData->name;
				$this->logaction->log($this->service,"Admin - Category '".$categoryData->name."' deleted - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}
	public function category_updateorder()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|numeric|max_length[3]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$this->downloads_categories_model->updateOrder($_POST['pk'],$_POST['value']);
		echo 1;
	}

	public function downloads_updateorder()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|numeric|max_length[6]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
		$this->form_validation->set_rules('name', 'Name', 'trim|required');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$name = "";
		$this->downloads_model->updateOrder($_POST['pk'],$_POST['value'],$_POST['name']);
		echo 1;
	}

	public function categorycheckname($id=0)
	{
		if($this->input->post('name')!='')
		{
			$slug=url_title($this->general_model->filtertext($this->input->post('name')));
			
			if(is_numeric($id))
			{
				$flag=$this->downloads_categories_model->checkName($this->general_model->filtertext(trim($this->input->post('name'))),$id);
				if($flag==1)
					echo 2;
				else
					echo 1;
			}
			else
				echo 0;
		}
	}

	public function uploadfiles()
	{
		$views = array('downloads/admin/upload');
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
	}
	
	public function upload()
	{
		$exts=$GLOBALS['site_settings']['blocked_file_types'];
		$excludedExtensions=explode("|",$exts);
		$json['files']=[];
		foreach ($_FILES['files']['name'] as $key => $file)
		{
			$ext=pathinfo ($_FILES['files']['name'][$key],PATHINFO_EXTENSION);

			if($_FILES['files']['size'][$key]==0)
			{
				$json['files'][] = array(
	            'name' => $file,
	            'size' => $_FILES['files']['size'][$key],
	            'type' => $_FILES['files']['type'][$key],
	            'error' => "Invalid File Size",
	            'status'=>0
	        	);
			}
			else if($_FILES['files']['size'][$key]>(25*1024*1024))
			{
				$json['files'][] = array(
	            'name' => $file,
	            'size' => $_FILES['files']['size'][$key],
	            'type' => $_FILES['files']['type'][$key],
	            'error' => "File Size exceeded 25 MB",
	            'status'=>0
	        	);
			}
			else if($ext=='' || in_array($ext,$excludedExtensions))
			{
				$json['files'][] = array(
	            'name' => $file,
	            'size' => $_FILES['files']['size'][$key],
	            'type' => $_FILES['files']['type'][$key],
	            'error' => "Extension not allowed",
	            'status'=>0
	        	);
			}
			else
			{	
        		$json['files'][0]=$this->downloads_model->uploadFile();
        		$json['files'][0]['name']=$file;
        		$json['files'][0]['type']=$_FILES['files']['type'][$key];
        		$json['files'][0]['size']=$_FILES['files']['size'][$key];
        		$json['files'][0]['status']=1;
        	}
		}
		echo json_encode($json);
	}
	public function delete($fileId=0)
	{
		$data['flag']=0;
		if(is_numeric($fileId) && $fileId)
		{
			$downloadData=$this->downloads_model->downloadData($fileId);
			if(empty($downloadData))
			{
				goto end;
			}
			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
			{
				if($downloadData->ashram_id!=$this->currentUser->ashram_id)
				{
					goto end;
				}
			}
			$r=$this->downloads_model->delete($downloadData);
			if($r)
			{
				$data['flag']=1;
				$data['filename']=$downloadData->description;
			}
		}
		end:
		echo json_encode($data);
	}
	public function updatedescription()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|max_length[500]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$downloadData=$this->downloads_model->downloadData($_POST['pk']);
		if(empty($downloadData))
		{
			echo 0;
			exit;
		}
		if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
		{
			if($downloadData->ashram_id!=$this->currentUser->ashram_id)
			{
				echo 0;
				exit;
			}
		}
		$this->downloads_model->updateDescription($_POST['pk'],$_POST['value']);
		echo 1;
	}
}
?>