<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Donorsadmin extends CI_Controller 
{
	var $currentUser='';
	var $service="donors";
	var $months=array(1=>"January",2=>"February",3=>"March",4=>"April",5=>"May",6=>"June",7=>"July",8=>"August",9=>"September",10=>"October",11=>"November",12=>"December");
	function __construct()
    {
        parent::__construct();
		
		$this->load->model("user/users_model");
		$this->load->model("subscriptions/donors_model");
		$this->currentUser=$this->session->userdata("admin_data");
    }

	public function index()
	{
		$data = array('views'=>array("donors/admin/list"));
		$data['countries']=$this->donors_model->getCountries();
		$this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function listc($excel=0)
	{
		if($this->currentUser->roles!=1 && $this->currentUser->roles!=12)
		{
			if(!$this->input->post("user_id"))
			{
				echo 0;
				exit;
			}
		}
		$list=$this->donors_model->listAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Donors listing ajax request");
	}

	public function donor_form($id=0)
	{
		$referer='';

		if(isset($_SERVER['HTTP_REFERER']) && $_SERVER['HTTP_REFERER']!='')
		{
			$referer=str_replace(base_url,"",$_SERVER['HTTP_REFERER']);
		}
		$from_checkout=0;
		$show_only_user_name = 0;
		if($referer=='donations/checkout' || $referer=='donations')
		{
			if(!$this->session->userdata("temp_checkout_user"))
			{
				echo 2;
				exit;
			}
			$from_checkout=1;
		}
		if($referer=='poojas/checkout' || $referer=='poojas')
		{
			if(!$this->session->userdata("temp_checkout_user"))
			{
				echo 2;
				exit;
			}
			$from_checkout=1;
		}
		if(is_numeric($id) && $id)
		{
			$donorData=$this->donors_model->donorData($id);
			if(empty($donorData))
			{
				$id=0;
			}
			else
			{
				$data['countryData']=$this->locations_model->getCountryByCode($donorData->donor_country_id);
			}
		}
		else
		{
			$donorData=array();
		}
		$userData=array();
		if(!empty($donorData))
		{
			$userData=$this->users_model->ProfileuserData($donorData->user_id);
		}
		if($from_checkout==1)
		{
			$userData=$this->session->userdata("temp_checkout_user");
		}
		$adding_from_admin = 0;
		if(isset($_GET['userid']) && ($_GET['userid']>0) )
		{
			$userData=$this->users_model->userData($_GET['userid']);
			$adding_from_admin = 1;
		}
		else if($this->session->userdata('temp_checkout_user'))
		{
			$userData=$this->session->userdata('temp_checkout_user');
			$show_only_user_name = 1;
		}
		$data['adding_from_admin']=$adding_from_admin;
		$data['from_checkout']=$from_checkout;
		$data['id']=$id;
		$data['donorData']=$donorData;
		$data['user']=$userData;
		$data['admin']=1;
		$data['show_only_user_name']=$show_only_user_name;
		echo $this->load->view("users/user/_donor_modal",$data,true);
	}

	public function add_donor2($id=0)
	{
		$result['flag']=0;
		$donorData=array();


		if(!isset($_POST['donor_dob_day']) || !isset($_POST['donor_dob_month']) || !isset($_POST['donor_email']) ||
			!isset($_POST['donor_star']) || !isset($_POST['donor_raasi']) || !isset($_POST['donor_profession']) ||
			!isset($_POST['donor_address']) || !isset($_POST['donor_user_id']))
		{
			$result['msg']="Invalid request";
			goto end;
		}

		$userData=$this->users_model->ProfileuserData($this->input->post("donor_user_id"));
		if(empty($userData))
		{
			$result['msg']="Invalid request";
			goto end;
		}

		if(!empty($this->input->post("donor_user_id")))
		{
			$selfDonorData=$this->donors_model->getUserSelfDonors($this->input->post("donor_user_id"));

			if(!empty($selfDonorData) && $selfDonorData == 1 && $_POST['donor_relation'] == "Self")
			{
				$result['msg']="Self donor cannot be created again..!";
				goto end;
			}
		}
		
		$this->form_validation->set_rules('donor_name', 'Name', 'trim|required|min_length[3]|max_length[200]');
		$this->form_validation->set_rules('donor_email', 'Email ID', 'trim|no_uppercase|valid_email_custom|min_length[6]|max_length[200]');
		$this->form_validation->set_rules('donor_phone', 'Phone', 'trim|required|numeric|min_length[8]|max_length[20]');
		$this->form_validation->set_rules('donor_address', 'Address', 'trim|min_length[3]|max_length[500]');
		$this->form_validation->set_rules('donor_country_code', 'Country code', 'trim|required|countryCheck');
		$this->form_validation->set_rules('donor_profession', 'Profession', 'trim|professionCheck');
		$this->form_validation->set_rules('donor_star', 'Birth Star', 'trim|starCheck');
		$this->form_validation->set_rules('donor_raasi', 'Raasi', 'trim|raasiCheck');
		$this->form_validation->set_rules('donor_dob_day', 'DOB Day', 'trim|dayCheck');
		$this->form_validation->set_rules('donor_dob_month', 'DOB Month', 'trim|monthCheck');

		if($this->form_validation->run() == FALSE)
		{
			$result['error']=validation_errors();
			$result['msg']="Invalid request";
			goto end;
		}

		if(isset($_FILES['donor_profile_image']))
			if($_FILES['donor_profile_image']['name']!='')
			{
				if($_FILES['donor_profile_image']['size']==0)
				{
					$result['msg']="Invalid photo";
					goto end;
				}
				$ext=pathinfo ($_FILES['donor_profile_image']['name'],PATHINFO_EXTENSION);

				if($ext=='')
				{
					$result['msg']="Invalid photo type";
					goto end;	
				}
				if(!getimagesize($_FILES['donor_profile_image']['tmp_name']))
				{
					$result['msg']="Invalid photo";
					goto end;
				}
				$file=1;
			}

		$saved=$this->donors_model->save(0,$donorData,$userData);
		if($saved)
		{
			$result['flag']=1;
		}
		else
		{
			$result['flag']=2;
		}


		end:
		echo json_encode($result);
	}

	public function edit_donor($id=0)
	{
		$result['flag']=0;
		if(is_numeric($id) && $id)
		{
			$donorData=$this->donors_model->donorData($id);

			if(empty($donorData))
			{
				$result['msg']="Invalid donor";
				goto end;
			}

			$selfDonorData=$this->donors_model->getUserSelfDonors($this->currentUser->sso_user_id);

			if(!empty($selfDonorData) && $selfDonorData == 1 && $_POST['donor_relation'] == "Self" && $donorData->id != $id)
			{
				$result['msg']="Self donor cannot be created again..!";
				goto end;
			}
		}
		else
		{
			$donorData=array();
		}


		if(!isset($_POST['donor_dob_day']) || !isset($_POST['donor_dob_month']) || !isset($_POST['donor_email']) ||
			!isset($_POST['donor_star']) || !isset($_POST['donor_raasi']) || !isset($_POST['donor_profession']) ||
			!isset($_POST['donor_address']) || !isset($_POST['donor_user_id']))
		{
			$result['msg']="Invalid request";
			goto end;
		}

		if(!$id)
		{
			$userData=$this->users_model->ProfileuserData($this->input->post("donor_user_id"));
			if(empty($userData))
			{
				$result['msg']="Invalid request";
				goto end;
			}
		}
		else
		{
			$userData=$this->users_model->ProfileuserData($donorData->user_id);
			if(empty($userData))
			{
				$result['msg']="Invalid request";
				goto end;
			}
		}
		
		$this->form_validation->set_rules('donor_name', 'Name', 'trim|required|min_length[3]|max_length[200]');
		$this->form_validation->set_rules('donor_email', 'Email ID', 'trim|no_uppercase|valid_email_custom|min_length[6]|max_length[200]');
		$this->form_validation->set_rules('donor_phone', 'Phone', 'trim|required|numeric|min_length[8]|max_length[20]');
		$this->form_validation->set_rules('donor_country_code', 'Country code', 'trim|required|countryCheck');
		$this->form_validation->set_rules('donor_profession', 'Profession', 'trim|professionCheck');
		$this->form_validation->set_rules('donor_star', 'Birth Star', 'trim|starCheck');
		$this->form_validation->set_rules('donor_raasi', 'Raasi', 'trim|raasiCheck');
		$this->form_validation->set_rules('donor_dob_day', 'DOB Day', 'trim|dayCheck');
		$this->form_validation->set_rules('donor_dob_month', 'DOB Month', 'trim|monthCheck');
		$this->form_validation->set_rules('donor_address', 'Address Line 1', 'trim|min_length[3]|max_length[100]');
		$this->form_validation->set_rules('donor_address1', 'Address Line 2', 'trim|min_length[3]|max_length[100]');
		$this->form_validation->set_rules('donor_address2', 'Address Line 3', 'trim|min_length[3]|max_length[100]');
		$this->form_validation->set_rules('donor_address_country_id', 'Country', 'trim|countryCheck');
		$this->form_validation->set_rules('donor_state', 'State', 'trim|min_length[2]|max_length[100]|name_validate13');
		$this->form_validation->set_rules('donor_city', 'City', 'trim|min_length[2]|max_length[100]|name_validate13');
		$this->form_validation->set_rules('donor_zipcode', 'ZIP Code', 'trim|alphabetsnumbers|min_length[3]|max_length[15]');

		if($this->form_validation->run() == FALSE)
		{
			$result['error']=validation_errors();
			$result['msg']="Invalid request";
			goto end;
		}

		if(isset($_FILES['donor_profile_image']))
			if($_FILES['donor_profile_image']['name']!='')
			{
				if($_FILES['donor_profile_image']['size']==0)
				{
					$result['msg']="Invalid photo";
					goto end;
				}
				$ext=pathinfo ($_FILES['donor_profile_image']['name'],PATHINFO_EXTENSION);

				if($ext=='')
				{
					$result['msg']="Invalid photo type";
					goto end;	
				}
				if(!getimagesize($_FILES['donor_profile_image']['tmp_name']))
				{
					$result['msg']="Invalid photo";
					goto end;
				}
				$file=1;
			}

		$saved=$this->donors_model->save($id,$donorData,$userData);
		if($saved)
		{
			$result['flag']=1;
		}
		else
		{
			$result['flag']=2;
		}


		end:
		echo json_encode($result);
	}

	public function delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$donorData=$this->donors_model->donorData($id);
			if(empty($donorData))
			{
				goto end;
			}
			$userData=$this->users_model->ProfileuserData($donorData->user_id);
			if(empty($userData))
			{
				goto end;
			}
			if($donorData->donor_relation == "Self")
			{
				$data['flag']=3;
				$data['name']=$donorData->donor_name;
				goto end;
			}
			$this->load->model("orders/orders_model");
			$count=$this->orders_model->orderItemsCountByDonorId($id);
			if($count>0)
			{
				$data['flag']=2;
				$data['name']=$donorData->donor_name;
				goto end;
			}
			$r=$this->donors_model->delete($id,$donorData,$userData);
			if($r)
			{
				$data['flag']=1;
				$data['name']=$donorData->donor_name;
				$this->logaction->log($this->service,"Donorsadmin - Donor ID '".$id."' deleted - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}
}
?>