<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Dailypostsadmin extends CI_Controller 
{
	var $service="content";
	var $currentUser='';
    function __construct() 
	{
        parent::__construct();
        if($this->session->userdata('id'))
		{
			$this->currentUser=$this->session->userdata("admin_data");
		}
		$this->load->model('content/dailyposts_model');
		$this->load->model('content/dailypost_types_model');
    }
	
	public function index()
	{
		$views = array( 'dailyposts/admin/list');
		$data = array('views'=>$views);
		$data['post_types']=$this->dailypost_types_model->getTypeList();
		$this->load->view(ADMIN_TEMPLATE,$data);
	}
	public function listposts($excel=0)
	{
		$list=$this->dailyposts_model->listAdmin($excel);
		echo json_encode($list);
	}
	public function post_types()
	{
		$views = array( 'dailyposts/admin/list_types');
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function listtypes($excel=0)
	{
		$list=$this->dailypost_types_model->listAdmin($excel);
		echo json_encode($list);
	}

	public function add_edit_post($id=0)
	{
		if($id)
		{
			$postData=$this->dailyposts_model->postData($id);
			if(empty($postData))
			{
				$this->session->set_flashdata("post_error",1);
				redirect("/dailypostsadmin");
			}
		}
		else
			$postData=array();

		if(isset($_POST["add_post"]))
		{
			if(!isset($_POST['content']) || !isset($_POST['type_id']))
			{
				$this->session->set_flashdata("post_error",1);
				redirect('dailypostsadmin/add_edit_post/'.$id);
			}

			$this->form_validation->set_rules('title', 'Post Title', 'trim|required|min_length[6]|max_length[200]');
			$this->form_validation->set_rules('date', 'Posted On', 'trim|required');
			$this->form_validation->set_rules('type_id', 'Post Type', 'trim|required|checkPostType');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("post_error",1);
				redirect('dailypostsadmin/add_edit_post/'.$id);
				return;
			}
			
			$saved=$this->dailyposts_model->save($id,$postData);
			if($saved)
			{
				if($id)
						$this->session->set_flashdata("post_saved",1);
				else
				{
					$this->session->set_flashdata("post_created",1);
				}
			}
			redirect('dailypostsadmin/add_edit_post/'.$saved);
		}
		else
		{	
		 	$views = array( 'dailyposts/admin/add_edit_post' );
		 	$data = array('views'=>$views,'id'=>$id);
		 	$data['post_types']=$this->dailypost_types_model->getTypeList();
			if($id)
			{
				$data['postData']=$postData;
			}
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}

	public function add_edit_post_type($id=0)
	{
		if($id)
		{
			$typeData=$this->dailypost_types_model->typeData($id);
			if(empty($typeData))
			{
				$this->session->set_flashdata("type_error",1);
				redirect("/dailypostsadmin/post_types");
			}
		}
		else
			$typeData=array();

		if(isset($_POST["add_type"]))
		{
			if(!isset($_POST['description']))
			{
				$this->session->set_flashdata("type_error",1);
				redirect('dailypostsadmin/add_edit_post_type/'.$id);
			}

			$this->form_validation->set_rules('name', 'Name', 'trim|required|min_length[6]|max_length[100]|postTypeNameCheck['.$id.']');
			$this->form_validation->set_rules('description', 'Description', 'trim|min_length[3]|max_length[500]');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("type_error",1);
				redirect('dailypostsadmin/add_edit_post_type/'.$id);
				return;
			}
			
			$saved=$this->dailypost_types_model->save($id,$typeData);
			if($saved)
			{
				if($id)
						$this->session->set_flashdata("type_saved",1);
				else
				{
					$this->session->set_flashdata("type_created",1);
				}
			}
			redirect('dailypostsadmin/add_edit_post_type/'.$saved);
			
		}
		else
		{
			
		 	$views = array( 'dailyposts/admin/add_edit_post_type' );
		 	$data = array('views'=>$views,'id'=>$id);
			if($id)
			{
				$data['typeData']=$typeData;
			}
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}

	public function delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$postData=$this->dailyposts_model->postData($id);
			if(empty($postData))
			{
				goto end;
			}
			$r=$this->dailyposts_model->delete($id,$postData);
			if($r)
			{
				$data['flag']=1;
				$data['title']=$postData->title;
				$this->logaction->log($this->service,"Admin - Post '".$postData->title."' deleted - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}

	function delete_type($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$typeData=$this->dailypost_types_model->typeData($id);
			if(empty($typeData))
			{
				goto end;
			}
			$r=$this->dailypost_types_model->delete($id,$typeData);
			if($r)
			{
				$data['flag']=1;
				$data['name']=$typeData->name;
				$this->logaction->log($this->service,"Admin - Post Type '".$typeData->name."' deleted - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}

	public function posttypecheckname($id=0)
	{
		if(isset($_POST['name']) && $_POST['name']!='')
		{
			$slug=url_title($this->general_model->filtertext($_POST['name']));
			if(strlen($slug)<6)
				echo 0;
			else
			{
				if(is_numeric($id))
				{
					$flag=$this->dailypost_types_model->checkName($this->general_model->filtertext(trim($_POST['name'])),$id);
					if($flag==1)
						echo 2;
					else
						echo 1;
				}
				else
					echo 0;
			}
		}
	}
	
}
?>