<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Cron_create_trust_80g_year_and_update_to_trust_account extends CI_Controller 
{
	var $service='ashrams';
	var $currentUser;
    function __construct() 
	{
        parent::__construct();
        if(!is_cli())
		{
			if($this->session->userdata('id'))
			{
				$this->currentUser=$this->session->userdata("admin_data");
			}
			else
			{
				$this->currentUser=$this->session->userdata("user_data");
			}
		}
		$this->load->model("ashrams/ashrams_trust_accounts_model");
    }
    public function index()
    {
    	$data['views'] = array('common/public/error');
		$this->load->view(FRONTEND_TEMPLATE,$data);
    }
    public function send()
	{
		if(is_cli())
		{
			$this->logaction->log($this->service,"Create trust 80g year note and update to 80 year into trust accounts CRON called");

			$yearStr = "";
			if(date('m')>=4)
            {
                $inrstartdate = date("Y")."-".financial_year_start_month_date;
                $inrenddate = (date("Y")+1)."-".financial_year_end_month_date;

                $yearStr = $inrstartdate."_to_".$inrenddate;
            }
            else
            {
                $inrstartdate = (date("Y")-1)."-".financial_year_start_month_date;
                $inrenddate = (date("Y"))."-".financial_year_end_month_date;

                $yearStr = $inrstartdate."_to_".$inrenddate;
            }

            if($yearStr!="")
            {
            	ini_set('max_execution_time', 0);
            	$this->db->select("a.*, b.trust_80g_year, b.trust_80g_note");
				$this->db->from("ashrams_trust_accounts as a");
				$this->db->join("trust_80g_years_note as b","b.id = a.trust_80g_year_id", "left");
		        $this->db->where("a.currency","inr");
				$inrTrusts = $this->db->get()->result();
	            foreach($inrTrusts as $inrTrust)
	            {
	            	$this->ashrams_trust_accounts_model->updateTrust80gNote($inrTrust->id,$yearStr,$inrTrust->tax_80g_501c3);
	            }
            }

			$this->logaction->log($this->service,"Create trust 80g year note and update to 80 year into trust accounts CRON completed");
		}
		else
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}	
}
?>