<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Cron_check_no_transaction_orders extends CI_Controller 
{
	var $currentUser;
	var $service="payments";
    function __construct()
	{
		parent::__construct();
		if(!is_cli())
		{
			if($this->session->userdata('id'))
			{
				$this->currentUser=$this->session->userdata("admin_data");
			}
			else
			{
				$this->currentUser=$this->session->userdata("user_data");
			}
		}
		$this->load->model("orders/orders_model");
		$this->load->model("orders/transaction_model");
    }
    public function index()
    {
    	if(is_cli())
		{
			$this->logaction->log("system","No transaction sevas CRON initiated");
			$fromDateTime = date("Y-m-d H:i:s", strtotime("-90 minutes"));  // yyyy-mm-dd hh:ii:ss
			$toDateTime = date("Y-m-d H:i:s", strtotime("-30 minutes"));  // yyyy-mm-dd hh:ii:ss;
			$fromOrderId = ""; // integer
			$toOrderId = ""; // integer
			$currencies = "inr,usd"; // inr,usd
			$paymentModes = "Stripe,Razorpay,PayPal"; //Stripe,Razorpay,PayPal
			$orderTypes = "1,2,3"; //1=poojas, 2=donations, 3=store and we are not accepting 4=subscriptions, because there is one day gap for tx  creation

			$sendRetryMail = "Yes"; // Yes/No
			$this->transaction_model->captureEvents($fromDateTime,$toDateTime,$fromOrderId,$toOrderId,$currencies,$paymentModes,$orderTypes,$sendRetryMail);
			$this->logaction->log("system","No transaction sevas CRON completed");
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
    }
}
?>