<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Contact extends CI_Controller 
{
	function __construct()
	{
        parent::__construct();
        if($this->session->userdata('id'))
        	$this->currentUser=$this->session->userdata("admin_data");
       	else
       		$this->currentUser=$this->session->userdata("user_data");

       	$this->load->model('contact_model');
       	$this->load->model('general_model');
       	$this->load->library("SES",null,"ses");
    }
	public function index()
	{
		$data['views'] = array('common/public/contact');
		$this->load->view(FRONTEND_TEMPLATE,$data);
	}
	public function send()
	{
		$data['flag']=0;
		if($this->session->userdata('id') && !$this->session->userdata('user_id'))
		{
			$data['flag']=2;
			goto end;
		}
		if(!$this->session->userdata('loggedIn'))
		{

			if(!isset($_POST["message"]) || !isset($_POST["purpose"]) || !isset($_POST["phone"]) ||
				!isset($_POST["name"]) || !isset($_POST["email"]))
			{
				goto end;
			}
		}
		else
		{
			if(!isset($_POST["message"]) || !isset($_POST["purpose"]) || !isset($_POST["phone"]))
			{
				goto end;
			}
		}

		$banned_emails=array_filter(explode(",",$GLOBALS['site_settings']['banned_emails_contact_techsupport']));
		if(!empty($banned_emails) && in_array($this->input->post("email"),$banned_emails))
		{
			goto success;
		}

		$this->form_validation->set_rules('message', 'Message', 'trim|required|max_length[1000]');
		$this->form_validation->set_rules('purpose', 'Purpose', 'trim|required|contactPurpose');
		$this->form_validation->set_rules('phone', 'Phone', 'trim|noSpaces|min_length[5]|max_length[100]');
		$this->form_validation->set_rules('c_country_code', 'Country code', 'trim|required|countryCheck');
		if(!$this->session->userdata('loggedIn'))
		{
			$this->form_validation->set_rules('name', 'Name', 'trim|required|min_length[3]|max_length[100]');
			$this->form_validation->set_rules('email', 'Email', 'trim|required|no_uppercase|valid_email_custom|min_length[6]|max_length[200]');
		}

		if ($this->form_validation->run() == FALSE)
		{
			goto end;
		}
		if($this->session->userdata('user_id'))
		{
			$uid=$this->session->userdata('user_id');
			$uData=$this->session->userdata("user_data");
			$name=$uData->firstname." ".$uData->lastname;
			$email=$uData->email;
		}
		else
		{
			$uid=0;
			$name=$this->input->post("name");
			$email=$this->input->post("email");
		}

		$countryData=$this->locations_model->getCountryByCode($this->input->post("c_country_code"));

		$this->contact_model->post($_POST,$name,$email);
		
        $this->load->model("email_extension_model");
		$settings=$this->email_extension_model->getSettingsByService('contact');

		$tempdata['name']=$name;
		$tempdata['email']=$email;
		$tempdata['phone']="+".$countryData->isd_code." ".$this->input->post("phone");
		$tempdata['purpose']=$this->input->post("purpose");
		$tempdata['content']=$this->input->post("message");
		$tempdata['app']=0;
        $content=$this->load->view("common/public/_contact_email",$tempdata,true);

        $viewData['name']="Admin";
		$viewData['body']=$content;
		$viewData['signature']=nl2br($settings->signature);
        $content=$this->load->view("common/templates/email_template",$viewData,true);

		$sender = '"'.$settings->from_name.'"<'.$settings->from_email.email_domain.'>';
		$ses_bcc = "";
		$messageID='';
		$subject = short_ashram_name." - New Contact message - ".$name;
		$sesResult = $this->ses->SendSESMail(0,$sender,contact_admin_email,$subject,$content,contact_admin_email_cc,"Contact");

		success:
        $data['flag']=1;


		end:
		echo json_encode($data);
	}
}
?>