<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Checklists extends CI_Controller 
{
	var $currentUser='';
    function __construct() 
	{
        parent::__construct();
        if($this->session->userdata('id'))
		{
			$this->currentUser=$this->session->userdata("admin_data");
		}
		$this->load->model('content/checklist_model');
    }
	
	function index()
	{
		$views = array('checklists/admin/checklists');
		$data = array('views'=>$views,"admin"=>1);
		$this->load->view(ADMIN_TEMPLATE,$data);
	}
	public function listrecords()
	{
		$list=$this->checklist_model->listByRoles($this->currentUser->roles);
		echo json_encode($list);
	}
	public function view($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$checklistData=$this->checklist_model->checklistData($id);
			if(!empty($checklistData))
			{
				$roles=explode(",", $this->currentUser->roles);
				if(!in_array($checklistData->role,$roles))
				{
					$this->session->set_flashdata("ck_error",1);
					redirect("checklists");
				}
				$views = array( 'checklists/admin/checklist_view' );
				$data = array('views'=>$views,'id'=>$id,"checklistData"=>$checklistData);
				$this->load->view(ADMIN_TEMPLATE,$data);
			}
			else
			{
				$this->session->set_flashdata("ck_error",1);
				redirect("checklists");
			}
		}
		else
		{
			$this->session->set_flashdata("ck_error",1);
			redirect("checklists");
		}
	}
}
?>