<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Bhajansadmin extends CI_Controller 
{
	var $currentUser='';
	var $service='content';
	var $cats=array("1"=>"Sri Swamiji - Ganesha Bhajans",
					"2"=>"Sri Swamiji - Datta Bhajans",
					"3"=>"Sri Swamiji - Tatvam Bhajans",
					"4"=>"Sri Swamiji - Devi Bhajans",
					"5"=>"Sri Swamiji - Other Bhajans",
					"6"=>"Sri Swamiji - Guru Bhajans",
					"7"=>"Sri Swamiji - Vishnu Bhajans",
					"8"=>"Sri Swamiji - Hanuman Bhajans",
					"9"=>"Sri Swamiji - Shiva Bhajans",
					"10"=>"Sri Swamiji - Skanda Bhajans",
					"11"=>"Sri Swamiji - Mangalam Bhajans",
					"12"=>"Sri Swamiji - Ugadi Bhajans");
    function __construct() 
	{
        parent::__construct();
		if($this->session->userdata('id'))
		{
			$this->currentUser=$this->session->userdata("admin_data");
		}
		$this->load->model("content/bhajans_model");
    }
    function index()
	{
		$views = array('bhajans/admin/list');
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data);
	}
	public function listc($excel=0)
	{
		$list=$this->bhajans_model->listAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Bhajans listing ajax request");
		
	}
	function uploadfiles()
	{
		$views = array('bhajans/admin/upload');
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data);
	}
	
	function upload()
	{
		$json['files']=[];
		foreach ($_FILES['files']['name'] as $key => $file)
		{
			$ext=pathinfo ($_FILES['files']['name'][$key],PATHINFO_EXTENSION);

			if($_FILES['files']['size'][$key]==0)
			{
				$json['files'][] = array(
	            'name' => $file,
	            'size' => $_FILES['files']['size'][$key],
	            'type' => $_FILES['files']['type'][$key],
	            'error' => "Invalid File Size",
	            'status'=>0
	        	);
			}
			else if($_FILES['files']['size'][$key]>(25*1024*1024))
			{
				$json['files'][] = array(
	            'name' => $file,
	            'size' => $_FILES['files']['size'][$key],
	            'type' => $_FILES['files']['type'][$key],
	            'error' => "File Size exceeded 25 MB",
	            'status'=>0
	        	);
			}
			else if($ext=='' || $ext!='pdf')
			{
				$json['files'][] = array(
	            'name' => $file,
	            'size' => $_FILES['files']['size'][$key],
	            'type' => $_FILES['files']['type'][$key],
	            'error' => "Extension not allowed",
	            'status'=>0
	        	);
			}
			else
			{	
        		$json['files'][0]=$this->bhajans_model->uploadFile();
        		$json['files'][0]['name']=$file;
        		$json['files'][0]['type']=$_FILES['files']['type'][$key];
        		$json['files'][0]['size']=$_FILES['files']['size'][$key];
        		$json['files'][0]['status']=1;
        	}
		}
		echo json_encode($json);
	}
	function delete($filekey='')
	{
		$data['flag']=0;
		if($filekey!='')
		{
			$keyData=$this->bhajans_model->getKeyData($filekey);
			if(empty($keyData))
			{
				goto end;
			}
			$r=$this->bhajans_model->delete($filekey);
			if($r)
			{
				$data['flag']=1;
				$data['count']=$r;
				$data['filename']=$keyData->description;
			}
		}
		end:
		echo json_encode($data);
	}
	public function updatedescription()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|max_length[500]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|checkBhajanKey');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$this->bhajans_model->updateDescription($_POST['pk'],$_POST['value']);
		echo 1;
	}
	public function updatecategory()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|numeric');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|checkBhajanKey');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$this->bhajans_model->updateCategory($_POST['pk'],$_POST['value']);
		echo 1;
	}
}
?>