<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Ashramcentersadmin extends CI_Controller 
{
	var $service='content';
    function __construct() 
	{
        parent::__construct();
		$this->load->model('content/ashramcenters_model');
		$this->load->model('content/ashramcenterpage_images_model');
		$this->load->model('locations_model');
		$this->currentUser=$this->session->userdata("admin_data");
    }
	function index()
	{
		$views = array( 'ashramcenters/admin/list' );
		$data = array('views'=>$views);
		$data['dyc_countries']=$this->ashramcenters_model->getCountries();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Ashram Centers Listing");
	}

	public function listc($excel=0)
	{
		$list=$this->ashramcenters_model->listAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Ashram Centers Listing ajax request");
	}
	
	function add_edit_ashramcenter($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$ashramcenterData=$this->ashramcenters_model->ashramcenterData($id);
			if(empty($ashramcenterData))
			{
				$this->session->set_flashdata("ashramcenter_error",1);
				redirect('ashramcentersadmin');
			}
		}
		else
		{
			$ashramcenterData=array();
		}

		if(isset($_POST["name"]))
		{
			if(!isset($_POST['description']))
			{
				$this->session->set_flashdata("ashramcenter_error",1);
				redirect('ashramcentersadmin/add_edit_ashramcenter/'.$id);
			}

			$this->form_validation->set_rules('name', 'Ashram Center Name', 'trim|required|min_length[6]|max_length[100]|checkAshramcenterName['.$id.']');
			$this->form_validation->set_rules('address', 'Address', 'trim|required|min_length[6]|max_length[500]');
			$this->form_validation->set_rules('country_id', 'Country', 'trim|required|checkCountry');
			$this->form_validation->set_rules('state_name', 'State', 'trim|required|min_length[2]|max_length[100]');
			$this->form_validation->set_rules('city', 'City', 'trim|required|min_length[2]|max_length[100]');
			$this->form_validation->set_rules('contact_person', 'Contact Person', 'trim|required|min_length[3]|max_length[100]');
			$this->form_validation->set_rules('contact_phone', 'Contact Phone', 'trim|required|min_length[8]|max_length[100]');
			$this->form_validation->set_rules('contact_email', 'Contact Email', 'trim|required|min_length[6]|max_length[100]|valid_email_custom');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("ashramcenter_error",1);
				redirect('ashramcentersadmin/add_edit_ashramcenter/'.$id);
				return;
			}
			$saved=$this->ashramcenters_model->save($id,$ashramcenterData);
			if($id==0)
			{
				$this->session->set_flashdata("dyc_created",1);
			}
			else
				$this->session->set_flashdata("dyc_saved",1);
			redirect('ashramcentersadmin/add_edit_ashramcenter/'.$saved);
			
		}
		else
		{
			if($id!='' && (empty($ashramcenterData)) )
			{
				redirect('ashramcentersadmin');
			}
			$views = array('ashramcenters/admin/add_edit_ashramcenter');
			$data = array('views'=>$views,'id'=>$id);
			$data['countries']=$this->locations_model->getCountries();
			if(is_numeric($id) && $id)
			{
				$data['ashramcenterData']=$ashramcenterData;
			}
			$this->load->view(ADMIN_TEMPLATE,$data); 
		}
	}

	function delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$ashramcenterData=$this->ashramcenters_model->ashramcenterData($id);
			if(empty($ashramcenterData))
			{
				goto end;
			}
			$r=$this->ashramcenters_model->delete($id,$ashramcenterData);
			if($r)
			{
				$data['flag']=1;
				$data['name']=$ashramcenterData->name;
				$this->logaction->log($this->service,"Admin - Ashram Center '".$ashramcenterData->name."' deleted - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}

	public function page($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$ashramcenterData=$this->ashramcenters_model->ashramcenterData($id);
			if(empty($ashramcenterData))
			{
				redirect("ashramcentersadmin");
			}

			if(isset($_POST['save_page']))	
			{
				if(isset($_POST['google_map_link']) && trim($_POST['google_map_link'])!="")
				{
					$this->form_validation->set_rules('google_map_link', 'Google Map Link', 'trim|checkGoogleMapLink');
				}
				$this->form_validation->set_rules('categories[]', 'Categories', 'checkAshramCenterCategories');
				$this->form_validation->set_rules('content', 'Content', 'trim');

				if(isset($_FILES['ashramcenter_image']['name']) && $_FILES['ashramcenter_image']['name']!='')
				{
					$allowed_file_types =   array('image/jpeg','image/jpg','image/png');
					$ext=pathinfo ($_FILES['ashramcenter_image']['name'],PATHINFO_EXTENSION);
					if($_FILES['ashramcenter_image']['size']==0 || $ext=='' || !in_array($_FILES['ashramcenter_image']['type'],$allowed_file_types) ||
							$_FILES['ashramcenter_image']['size']>(10*1024*1024))
					{
						$this->session->set_flashdata("page_error",1);
						redirect("ashramcentersadmin/page/".$id);
					}
				}

				if($this->form_validation->run() == FALSE)
				{
					$this->session->set_flashdata("page_error",1);
					redirect("ashramcentersadmin/page/".$id);
				}
				$this->ashramcenters_model->savePage($id);
				$this->session->set_flashdata("saved_page",1);
				redirect("ashramcentersadmin/page/".$id);
			}
			else
			{
				$views = array( 'ashramcenters/admin/page' );
				$data = array('views'=>$views);
				$data['ashramcenterData']=$ashramcenterData;
				$data['id']=$id;
				$this->load->view(ADMIN_TEMPLATE,$data);
			}
		}
	}

	public function namecheck($id=0)
	{
		if(isset($_POST['name']) && $_POST['name']!='' && is_numeric($id))
		{
			$slug=url_title($this->general_model->filtertext($_POST['name']));
			if(strlen($slug)<6)
			{
				echo "false";
			}
			else
			{
				if(is_numeric($id))
				{
					$flag=$this->ashramcenters_model->checkName($this->general_model->filtertext(trim($_POST['name'])),$id);

					if($flag==0)
						echo "true";
					else
						echo "false";
				}
				else
					echo "false";
			}
		}
		else
		{
			echo "false";
		}
	}
}
?>