<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Ashramadmin extends CI_Controller 
{
	var $currentUser='';
	var $service='ashrams';
    function __construct() 
	{
        parent::__construct();
		$this->load->model('ashrams/ashrams_model');
		$this->load->model('ashrams/ashram_calendar_model');
		$this->load->model('ashrams/announcements_model');
		$this->load->model('ashrams/ashrampage_images_model');
		$this->load->model('ashrams/ashram_members_model');
		$this->load->model('currencies_model');
		$this->load->model("ashrams/ashrams_trust_accounts_model");
		$this->load->model('locations_model');
		$this->load->model("ashrams/ashram_newsletters_model");
		$this->load->model("ashrams/ashram_newsletter_images_model");
		$this->load->model("ashrams/newsletters_que_model");
		$this->load->model("ashrams/newsletters_sms_que_model");
		$this->currentUser=$this->session->userdata("admin_data");
		if(is_single_ashram_site)
        { 
            $this->session->set_userdata("ashramId",default_ashram_id); 
		}
    }
	public function index()
	{
		$views = array( 'ashrams/admin/list' );
		$data = array('views'=>$views);
		$data['ashram_countries']=$this->ashrams_model->getCountries();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Ashrams Listing");
	}

	public function announcements()
	{
		$views = array( 'ashrams/admin/list_announcements' );
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Announcements Listing");
	}
	public function listc($excel=0)
	{
		$list=$this->ashrams_model->listAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Ashrams Listing ajax request");
	}
	
	public function listannouncements($excel=0)
	{
		$list=$this->announcements_model->listAdmin($this->session->userdata("ashramId"),$excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Announcements Listing ajax request");
	}
	
	public function add_edit_ashram($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$ashramData=$this->ashrams_model->ashramData($id);
			if(empty($ashramData))
			{
				$this->session->set_flashdata("ashram_error",1);
				redirect('ashramadmin');
			}
		}
		else
		{
			$ashramData=array();
		}

		if(isset($_POST["name"]))
		{

			if(!isset($_POST['description']))
			{
				$this->session->set_flashdata("ashram_error",1);
				redirect('ashramadmin/add_edit_ashram/'.$id);
			}

			$this->form_validation->set_rules('name', 'Ashram Name', 'trim|required|min_length[3]|max_length[100]|checkAshramName['.$id.']');
			$this->form_validation->set_rules('alias_name', 'Ashram Alias Name', 'trim|required|min_length[3]|max_length[100]');
			$this->form_validation->set_rules('show_alias_name_as_ashram_name', 'Show Alias Name as Ashram Name in Orders? ', 'trim|required|numeric|checkShowAliasNameAsAshramNameInOrders');
			$this->form_validation->set_rules('address', 'Address', 'trim|required|min_length[6]|max_length[500]');
			$this->form_validation->set_rules('country_id', 'Country', 'trim|required|checkCountry');
			$this->form_validation->set_rules('state_name', 'State', 'trim|required|min_length[2]|max_length[100]');
			$this->form_validation->set_rules('city', 'City', 'trim|required|min_length[2]|max_length[100]');
			$this->form_validation->set_rules('contact_person', 'Contact Person', 'trim|required|min_length[3]|max_length[100]');
			$this->form_validation->set_rules('contact_phone', 'Contact Phone', 'trim|required|min_length[8]|max_length[100]');
			$this->form_validation->set_rules('contact_email', 'Contact Email', 'trim|required|min_length[6]|max_length[100]|valid_email_custom');
			$this->form_validation->set_rules('is_public_display', 'Is Public Diaply? ', 'trim|required|numeric|checkPublicDisplay');
			$this->form_validation->set_rules('is_pan_required_for_inr', 'PAN (INR) Required? ', 'trim|required|numeric|checkPanRequiredForInr');
			$this->form_validation->set_rules('declaration_type', 'Letter Template Type ', 'trim|required|checkDeclarationType');
			if(isset($_POST['declaration_type']) && $_POST['declaration_type'] == "Gift")
			{
				$this->form_validation->set_rules('gift_inr_templates', 'INR Gift Templates', 'trim|required|checkDeclarationTemplates');
				$this->form_validation->set_rules('gift_usd_templates', 'USD Gift Templates', 'trim|required|checkDeclarationTemplates');
			}

			$this->form_validation->set_rules('is_poojas_report_email', 'Send Poojas Report Mail ', 'trim|required|numeric|checkSendPoojasReportMail');
			if(isset($_POST['is_poojas_report_email']) && $_POST['is_poojas_report_email'] == 1)
			{
				$this->form_validation->set_rules('poojas_report_emails', 'Poojas Reporting Emails ', 'trim|required|checkPoojasReportEmails');
			}
			$this->form_validation->set_rules('is_donations_report_email', 'Send Donations Report Mail ', 'trim|required|numeric|checkSendDonationsReportMail');
			if(isset($_POST['is_donations_report_email']) && $_POST['is_donations_report_email'] == 1)
			{
				$this->form_validation->set_rules('donations_report_emails', 'Donations Reporting Emails ', 'trim|required|checkDonationsReportEmails');
			}
			$this->form_validation->set_rules('is_store_report_email', 'Send Store Report Mail ', 'trim|required|numeric|checkSendStoreReportMail');
			if(isset($_POST['is_store_report_email']) && $_POST['is_store_report_email'] == 1)
			{
				$this->form_validation->set_rules('store_report_emails', 'Store Reporting Emails ', 'trim|required|checkStoreReportEmails');
			}
			$this->form_validation->set_rules('is_subscriptions_report_email', 'Send Subscriptions Report Mail ', 'trim|required|numeric|checkSendSubscriptionsReportMail');
			if(isset($_POST['is_subscriptions_report_email']) && $_POST['is_subscriptions_report_email'] == 1)
			{
				$this->form_validation->set_rules('subscriptions_report_emails', 'Subscriptions Reporting Emails ', 'trim|required|checkSubscriptionsReportEmails');
			}

			if(isset($_FILES['ashram_image']['name']) && $_FILES['ashram_image']['name']!='')
			{
				$allowed_file_types =   array('image/jpeg','image/jpg','image/png');
				$ext=pathinfo ($_FILES['ashram_image']['name'],PATHINFO_EXTENSION);
				if($_FILES['ashram_image']['size']==0 || $ext=='' || !in_array($_FILES['ashram_image']['type'],$allowed_file_types) ||
						$_FILES['ashram_image']['size']>(10*1024*1024))
				{
					$this->session->set_flashdata("ashram_error",1);
					redirect('ashramadmin/add_edit_ashram/'.$id);
				}
			}

			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("ashram_error",1);
				redirect('ashramadmin/add_edit_ashram/'.$id);
				return;
			}
			$this->load->model("user/users_model");
			$this->load->model("ashrams/ashrams_trust_accounts_model");
			$saved=$this->ashrams_model->save($id,$ashramData);
			if($id==0)
			{
				$this->session->set_flashdata("ashram_created",1);
			}
			else
				$this->session->set_flashdata("ashram_saved",1);
			redirect('ashramadmin/add_edit_ashram/'.$saved);
			
		}
		else
		{
			if($id!='' && (empty($ashramData)) )
			{
				redirect('ashramadmin');
			}
			$views = array('ashrams/admin/add_edit_ashram');
			$data = array('views'=>$views,'id'=>$id);
			$data['countries']=$this->locations_model->getCountries();
			$data['ashram_currencies']=$this->currencies_model->getByAshram($id);
			if(is_numeric($id) && $id)
			{
				$data['ashramData']=$ashramData;
			}
			$this->load->view(ADMIN_TEMPLATE,$data); 
		}
	}

	public function add_edit_announcement($id=0)
	{
		if(!$this->session->userdata("ashramId"))
		{
			redirect("ashramadmin");
		}
		if(is_numeric($id) && $id)
		{
			$announcementData=$this->announcements_model->announcementData($id);
			if(empty($announcementData))
			{
				$this->session->set_flashdata("announcement_error",1);
				redirect('ashramadmin/announcements');
			}
		}
		else
		{
			$announcementData=array();
		}

		if(isset($_POST["save_announcement"]))
		{
			if(!isset($_POST['content']))
			{
				$this->session->set_flashdata("announcement_error",1);
				redirect('ashramadmin/add_edit_announcement/'.$id);
			}

			$this->form_validation->set_rules('title', 'Title', 'trim|required|min_length[6]|max_length[200]');
			$this->form_validation->set_rules('published_on', 'Publish Date', 'trim|required|valid_date');
			
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("announcement_error",1);
				redirect('ashramadmin/add_edit_announcement/'.$id);
				return;
			}
			$saved=$this->announcements_model->save($id,$announcementData);
			if($id==0)
			{
				$this->session->set_flashdata("announcement_created",1);
			}
			else
				$this->session->set_flashdata("announcement_saved",1);
			redirect('ashramadmin/add_edit_announcement/'.$saved);
			
		}
		else
		{
			if($id!='' && (empty($announcementData)) )
			{
				redirect('ashramadmin/announcements');
			}
			$views = array('ashrams/admin/add_edit_announcement');
			$data = array('views'=>$views,'id'=>$id);
			if($this->currentUser->roles==1)
        	{
        		$data['ashrams']=$this->ashrams_model->getList();
        	}
			$data['ashramData']=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
			if(is_numeric($id) && $id)
			{
				$data['announcementData']=$announcementData;
			}
			$this->load->view(ADMIN_TEMPLATE,$data); 
		}
	}

	/*public function delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$ashramData=$this->ashrams_model->ashramData($id);
			if(empty($ashramData))
			{
				goto end;
			}
			$r=$this->ashrams_model->delete($id,$ashramData);
			if($r)
			{
				$data['flag']=1;
				$data['name']=$ashramData->name;
				$this->logaction->log($this->service,"Admin - Ashram '".$ashramData->name."' deleted - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}*/

	public function changestatus($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id && $this->session->userdata("ashramId") && isset($_POST['status']) && is_numeric($_POST['status']) && in_array($_POST['status'],array(0,1)))
		{
			$announcementData=$this->announcements_model->announcementData($id);
			if(empty($announcementData))
			{
				goto end;
			}
			$data['title']=$announcementData->title;
			if($announcementData->status==$_POST['status'])
			{
				$data['flag']=2;
				goto end;
			}
			$this->announcements_model->changeStatus($id,$_POST['status']);
			
			$data['flag']=1;
			
			if($_POST['status']==1)
				$this->logaction->log($this->service,"Admin - Announcement '".$announcementData->title."' activated - ".$id);
			else
				$this->logaction->log($this->service,"Admin - Announcement '".$announcementData->title."' deactivated - ".$id);
		}
		end:
		echo json_encode($data);
	}

	public function delete_announcement($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$announcementData=$this->announcements_model->announcementData($id);
			if(empty($announcementData))
			{
				goto end;
			}
			$r=$this->announcements_model->delete($id,$announcementData);
			if($r)
			{
				$data['flag']=1;
				$data['title']=$announcementData->title;
				$this->logaction->log($this->service,"Admin - Announcement '".$announcementData->title."' deleted - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}
	public function switchashram($ashramId=0)
	{
		if(is_numeric($ashramId))
			$this->session->set_userdata("ashramId",$ashramId);
		if($this->session->userdata("pooja_categoryId"))
			$this->session->unset_userdata("pooja_categoryId");
		if($this->session->userdata("donation_categoryId"))
			$this->session->unset_userdata("donation_categoryId");
		if($this->session->userdata("store_categoryId"))
			$this->session->unset_userdata("store_categoryId");
		if($this->session->userdata("subscription_categoryId"))
			$this->session->unset_userdata("subscription_categoryId");
		if($this->session->userdata("groupId"))
			$this->session->unset_userdata("groupId");
	}

	public function switchUserashram($ashramId=0)
	{
		if(is_numeric($ashramId))
			$this->session->set_userdata("ashramId",$ashramId);
		if($this->session->userdata("pooja_categoryId"))
			$this->session->unset_userdata("pooja_categoryId");
		if($this->session->userdata("donation_categoryId"))
			$this->session->unset_userdata("donation_categoryId");
		if($this->session->userdata("store_categoryId"))
			$this->session->unset_userdata("store_categoryId");
		if($this->session->userdata("subscription_categoryId"))
			$this->session->unset_userdata("subscription_categoryId");
		if($this->session->userdata("groupId"))
			$this->session->unset_userdata("groupId");
	}

	public function members()
	{
		$views = array( 'ashrams/admin/list_members' );
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Ashram Members Listing");
	}
	public function listm($excel=0)
	{
		if($this->session->userdata("ashramId"))
		{
			$list=$this->ashram_members_model->listAdmin($excel);
			echo json_encode($list);
			$this->logaction->log($this->service,"Admin - Viewed Ashram Members Listing ajax request");
		}
	}

	public function settings()
	{
		$views = array( 'ashrams/admin/settings' );
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		$data['ashram_currencies']=$this->currencies_model->getByAshram($this->session->userdata("ashramId"));

		if(is_single_currency_site)
        { 
            $this->session->set_userdata("trustCurrency",default_currency); 
		}
		else if(!$this->session->userdata("trustCurrency"))
		{
			$this->session->set_userdata("trustCurrency","inr");
		}

		if($this->session->userdata("ashramId")!=0 && $this->session->userdata("trustCurrency")!="")
		{
			$data['poojaTrusts']=$this->ashrams_trust_accounts_model->getActiveTrustsByAshramIdCurrency($this->session->userdata("ashramId"),1,$this->session->userdata("trustCurrency"));
			$data['donationsTrusts']=$this->ashrams_trust_accounts_model->getActiveTrustsByAshramIdCurrency($this->session->userdata("ashramId"),2,$this->session->userdata("trustCurrency"));
			$data['storeTrusts']=$this->ashrams_trust_accounts_model->getActiveTrustsByAshramIdCurrency($this->session->userdata("ashramId"),3,$this->session->userdata("trustCurrency"));
			$data['subscriptionsTrusts']=$this->ashrams_trust_accounts_model->getActiveTrustsByAshramIdCurrency($this->session->userdata("ashramId"),4,$this->session->userdata("trustCurrency"));

			$data['trustData'] = $this->ashrams_trust_accounts_model->getTrustsByAshramCurrency($this->session->userdata("trustCurrency"));
		}

		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Ashram Settings");
	}

	public function switchtrustcurrency($currency='')
	{
		$this->session->set_userdata("trustCurrency",$currency);
	}

	public function switchCurrency()
	{
		$data['poojaTrusts']=$this->ashrams_trust_accounts_model->getActiveTrustsByAshramIdCurrency($this->session->userdata("ashramId"),1,$_POST['currency']);
		$data['donationsTrusts']=$this->ashrams_trust_accounts_model->getActiveTrustsByAshramIdCurrency($this->session->userdata("ashramId"),2,$_POST['currency']);
		$data['storeTrusts']=$this->ashrams_trust_accounts_model->getActiveTrustsByAshramIdCurrency($this->session->userdata("ashramId"),3,$_POST['currency']);
		$data['subscriptionsTrusts']=$this->ashrams_trust_accounts_model->getActiveTrustsByAshramIdCurrency($this->session->userdata("ashramId"),4,$_POST['currency']);
		$this->load->view('ashrams/admin/trust_form',$data);
	}

	/**
	 * getting all trusts in grid view
	 *@category ajax
	 *@return  void
	 */
	public function getTrustGrid()
	{
		$data['trustData'] = $this->ashrams_trust_accounts_model->getTrustsByAshramCurrency($_POST['currency']);
		echo $this->load->view('ashrams/admin/list_trusts',$data, TRUE);
		exit;
	}

	public function listsettings($excel=0)
	{
		$this->load->model("ashrams/ashrams_trust_accounts_model");
		$list=$this->ashrams_trust_accounts_model->listAdmin($this->session->userdata("ashramId"),$excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Announcements Listing ajax request");
	}
	public function updatesettings($flag=1)
	{
		if(isset($_POST['name']) && isset($_POST['value']) && isset($_POST['pk']) && in_array($flag,array(1,2,3,4)))
		{
			if($flag==1)
			{
				if($_POST['name']!='description' && $_POST['name']!='address')
				{
					echo "Invalid request";
					return;
				}
				if(trim($_POST['value'])=='')
				{
					echo "Value cannot be empty";
					return;
				}
				if(strlen(trim($_POST['value']))>500)
				{
					echo "Value cannot be more than 500 characters";
					return;
				}
			}
			if($flag==2)
			{
				if($_POST['name']!='trust_name' && $_POST['name']!='account_number' && $_POST['name']!='contact_person' && 
					$_POST['name']!='payu_merchantkey' && $_POST['name']!='payu_salt' && $_POST['name']!='payflow_partner' &&
					$_POST['name']!='payflow_user' && $_POST['name']!='payflow_pwd' && $_POST['name']!='ashram_footer'  &&
					$_POST['name']!='ashram_name' && $_POST['name']!='payflow_vendor' && $_POST['name']!='razorpay_key' &&
					$_POST['name']!='razorpay_secret' && $_POST['name']!='authorizenet_login' && $_POST['name']!='authorizenet_key' &&
					$_POST['name']!='stripe_public_key' && $_POST['name']!='stripe_secret_key')
				{
					echo "Invalid request";
					return;
				}
				if(trim($_POST['value'])=='')
				{
					echo "Value cannot be empty";
					return;
				}
				if(strlen(trim($_POST['value']))>200)
				{
					echo "Value cannot be more than 200 characters";
					return;
				}
			}

			if($flag==3)
			{
				if($_POST['name']!='tax_80g_501c3')
				{
					echo "Invalid request";
					return;
				}
				if(strlen(trim($_POST['value']))>500)
				{
					echo "Value cannot be more than 500 characters";
					return;
				}
			}
			if($flag==4)
			{
				if($_POST['name']!='payment_mode')
				{
					echo "Invalid request";
					return;
				}
				if(!in_array($_POST['value'],array("payu","paypal","razorpay","authorize.net","stripe")))
				{
					echo "Invalid value";
					return;
				}
			}
			$this->load->model("ashrams/ashrams_trust_accounts_model");
			$this->ashrams_trust_accounts_model->updateSettings($_POST['pk'],$_POST['name'],$_POST['value']);
			echo 1;
		}
	}

	public function update_currency()
	{
		$result['flag']=0;
		if(!$this->session->userdata("ashramId"))
		{
			goto end;
		}
		if(!isset($_POST['currency']) || !isset($_POST['action']) || !in_array($_POST['action'], array(0,1)))
			goto end;

		$global_currency=$this->currencies_model->getByAshram(0,$_POST['currency']);
		
		if(empty($global_currency))
			goto end;

		$response=$this->currencies_model->update($_POST['currency'],$this->session->userdata("ashramId"),$_POST['action']);
		$result['flag']=$response;
		end:
		echo json_encode($result);
	}

	//============================CALENDAR===========================
	public function calendar()
	{
		$views = array( 'ashrams/admin/list_calendar' );
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Calendar Listing");
	}

	public function listcalendar($excel=0)
	{
		if($this->session->userdata("ashramId"))
		{
			$list=$this->ashram_calendar_model->listAdmin($excel);
			echo json_encode($list);
			$this->logaction->log($this->service,"Admin - Viewed Calendar Listing ajax request");
		}
	}

	public function add_edit_calendar($id=0)
	{
		if(!$this->session->userdata("ashramId"))
		{
			redirect("ashramadmin/calendar");
		}
		if(is_numeric($id) && $id)
		{
			$calendarData=$this->ashram_calendar_model->calendarData($id);
			if(empty($calendarData))
			{
				$this->session->set_flashdata("calendar_error",1);
				redirect('ashramadmin/calendar');
			}
			if($calendarData->ashram_id!=$this->session->userdata("ashramId"))
			{
				$this->session->set_flashdata("calendar_error",1);
				redirect('ashramadmin/calendar');
			}
		}
		

		if(isset($_POST["save_calendar"]))
		{
			if(!isset($_POST['description']))
			{
				$this->session->set_flashdata("calendar_error",1);
				redirect('ashramadmin/add_edit_calendar/'.$id);
			}

			$this->form_validation->set_rules('event_name', 'Calendar Event', 'trim|required|min_length[6]|max_length[200]');
			$this->form_validation->set_rules('start_date', 'Start Date', 'trim|required');
			if(isset($_POST['start_date']))
				$this->form_validation->set_rules('end_date', 'End Date', 'trim|required|calendarDateRangeCheck');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("calendar_error",1);
				redirect('ashramadmin/add_edit_calendar/'.$id);
				return;
			}

			$saved=$this->ashram_calendar_model->save($id);
			if($id==0)
			{
				$this->session->set_flashdata("calendar_created",1);
			}
			else
				$this->session->set_flashdata("calendar_saved",1);
			redirect('ashramadmin/add_edit_calendar/'.$saved);
			
		}
		else
		{
			$views = array('ashrams/admin/add_edit_calendar');
			$data = array('views'=>$views,'id'=>$id);
			if($this->currentUser->roles==1)
        	{
        		$data['ashrams']=$this->ashrams_model->getList();
        	}
			$data['ashramData']=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
			if(is_numeric($id) && $id)
			{
				$data['calendarData']=$calendarData;
			}
			$this->load->view(ADMIN_TEMPLATE,$data); 
		}
	}

	public function delete_calendar($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$calendarData=$this->ashram_calendar_model->calendarData($id);
			if(empty($calendarData))
			{
				goto end;
			}
			if($calendarData->ashram_id!=$this->session->userdata("ashramId"))
			{
				goto end;
			}
			$r=$this->ashram_calendar_model->delete($id);
			if($r)
			{
				$data['flag']=1;
				$data['event_name']=$calendarData->event_name;
				$this->logaction->log($this->service,"Admin - Calendar event '".$calendarData->event_name."' deleted - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}

	public function page()
	{
		$ashramData=array();
		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
			if(empty($ashramData))
			{
				redirect("ashramadmin");
			}
		}

		if(isset($_POST['save_page']))	
		{
			if(!isset($_POST['content']))
			{
				redirect("ashramadmin/page");
			}
			$this->ashrams_model->savePage();
			$this->session->set_flashdata("saved_page",1);
			redirect("ashramadmin/page");
		}
		else
		{
			$views = array( 'ashrams/admin/page' );
			$data = array('views'=>$views);
			$data['ashrams']=$this->ashrams_model->getList();
			$data['ashramData']=$ashramData;
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}

	public function namecheck($id=0)
	{
		if(isset($_POST['name']) && $_POST['name']!='' && is_numeric($id))
		{
			$slug=url_title($this->general_model->filtertext($_POST['name']));

			if(strlen($slug)<3)
			{
				echo "false";
			}
			else
			{
				if(is_numeric($id))
				{
					$flag=$this->ashrams_model->checkName($this->general_model->filtertext(trim($_POST['name'])),$id);

					if($flag==0)
						echo "true";
					else
						echo "false";
				}
				else
					echo "false";
			}
		}
		else
		{
			echo "false";
		}
	}

	public function ashram_updateorder()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|numeric|max_length[3]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$this->ashrams_model->updateOrder($_POST['pk'],$_POST['value']);
		echo 1;
	}

	public function subscribe_unsubscribe_ashram_user($id=0,$status=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$memberData=$this->ashram_members_model->getMemberById($id);
			if(empty($memberData))
			{
				goto end;
			}
			$this->ashram_members_model->updateReceiveNewslettersStatus($id, $status);
			$data['flag']=1;
			$data['username']='';
			$memberFulldata = $this->ashram_members_model->getMemberDetailsById($id);
			if(isset($memberFulldata->username) && $memberFulldata->username!='')
			{
				$data['username']=$memberFulldata->username;
			}
		}
		end:
		echo json_encode($data);
	}

	public function checkDeclarationInrTemplateExists()
	{
		$returnval = 'false';
		if(isset($_POST['gift_inr_templates']) && $_POST['gift_inr_templates']!='')
		{
			$this->form_validation->set_rules('gift_inr_templates', 'Declaration Templates', 'trim|required|checkDeclarationTemplates');
			if($this->form_validation->run() == FALSE)
			{
				$returnval ='false';
			}
			else
			{
				$returnval ='true';
			}
		}
		echo $returnval;
		return; 
	}

	public function checkDeclarationUsdTemplateExists()
	{
		$returnval = 'false';
		if(isset($_POST['gift_usd_templates']) && $_POST['gift_usd_templates']!='')
		{
			$this->form_validation->set_rules('gift_usd_templates', 'Declaration Templates', 'trim|required|checkDeclarationTemplates');
			if($this->form_validation->run() == FALSE)
			{
				$returnval ='false';
			}
			else
			{
				$returnval ='true';
			}
		}
		echo $returnval;
		return; 
	}

	/**
	 * Loads the Trust add/edit Page
	 *
	 * @return  void
	 */
	public function add_edit_trust($id=0)
	{
		if(!$this->session->userdata("trustCurrency") || !$this->session->userdata("ashramId"))
		{
			redirect('ashramadmin/settings');
		}
		if(is_numeric($id) && $id)
		{
			$trustData=$this->ashrams_trust_accounts_model->trustData($id);
			if(empty($trustData))
			{
				$this->session->set_flashdata("trust_error",1);
				redirect('ashramadmin/settings');
			}
		} else {
			$trustData=array();
		}
		if(isset($_POST["name"]))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
			if(isset($ashramData->name))
			{
				$_POST['name'] = $ashramData->name;
			}
			$this->form_validation->set_rules('name', 'Ashram Name', 'trim|required|min_length[6]|max_length[200]');
			if($id==0)
			{
				$this->form_validation->set_rules('trustaccfor', 'Trust Account Seva', 'trim|required');
			}
			$this->form_validation->set_rules('trust_basic_id', 'Basic Trust Details', 'trim|required|checkBasicTrust');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("trust_error",1);
				redirect('ashramadmin/add_edit_trust/'.$id);
				return;
			}

			$saved=$this->ashrams_trust_accounts_model->saveTrust($id);
			if($id==0)
			{
				$this->session->set_flashdata("trust_created",1);
			}
			else
				$this->session->set_flashdata("trust_saved",1);
			redirect('ashramadmin/add_edit_trust/'.$saved);
		} else {
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
			if($id!='' && (empty($trustData)) )
			{
				redirect('ashramadmin/settings');
			}
			$views = array('ashrams/admin/add_edit_trust');
			$data = array('views'=>$views,'id'=>$id);
			if($id>0)
			{
				$data['basicTrusts'] = $this->ashrams_trust_accounts_model->getAllBasciTrusts($trustData->currency);
			}
			else
			{
				$data['basicTrusts'] = $this->ashrams_trust_accounts_model->getAllBasciTrusts($this->session->userdata("trustCurrency"));
			}
			if(is_numeric($id) && $id)
			{
				$data['trustBasicData'] = $this->ashrams_trust_accounts_model->trustBasicDataById($trustData->trust_basic_id);
				$data['trustData']=$trustData;
			}
			$data['ashramData'] = $ashramData;
			$this->load->view(ADMIN_TEMPLATE,$data); 
		}
	}


	/**
	 * checking seva trust limit for both inr and usd currency
	 *@category ajax
	 *@return  void
	 */
	public function sevaCheck()
	{
		$count = $this->ashrams_trust_accounts_model->getTrustsByAshramCurrency($_POST['currency'],$_POST['trustaccfor']);
		if(count($count)>=5)
			echo "false";
		else
			echo "true";
	}


	


	/**
	 * making Trust as active / in-active
	 *@category ajax
	 *@return  void
	 */
	public function changeTrustStatus()
	{
		$trustDetails = $this->ashrams_trust_accounts_model->trustData($_POST['id']);
		if(empty($trustDetails))
		{
			echo 'trustNotFound';
			exit;
		}
		if($trustDetails->trust_status==1)
		{
			echo 'trustIsAlreadyAssignedForPayment';
			exit;
		}
		$cyrrency = $this->ashrams_trust_accounts_model->updateTrustStatus();
		if($cyrrency){
			$data['trustData'] = $this->ashrams_trust_accounts_model->getTrustsByAshramCurrency($cyrrency);
			echo $this->load->view('ashrams/admin/list_trusts',$data, TRUE);
			exit;
		} else {
			return false;
		}
	}


	


	/**
	 * getting Payment modes based on their credentials
	 *@category ajax
	 *@return  void
	 */
	public function getGateway()
	{
		$gateway=$this->ashrams_trust_accounts_model->trustData($_POST['trust']);
		$gatewayArray = array();
		if($gateway->payflow_user!='')
			$gatewayArray[] = 'paypal';
		if($gateway->payu_merchantkey!='')
			$gatewayArray[] = 'payu';
		if($gateway->razorpay_key!='')
			$gatewayArray[] = 'razorpay';
		if($gateway->stripe_public_key!='')
			$gatewayArray[] = 'stripe';
		echo json_encode($gatewayArray);
		exit;
	}


	/**
	 * for add/edit Trust settings for Ashram
	 *@category ajax
	 *@return  void
	 */
	public function settingsupdate()
	{
		if(isset($_POST['pooja_trust']) && $_POST['pooja_trust']!="")
		{
			$this->form_validation->set_rules('pooja_gateway', 'Pooja Gateway', 'trim|required');
		}
		if(isset($_POST['donation_trust']) && $_POST['donation_trust']!="")
		{
			$this->form_validation->set_rules('donation_gateway', 'Donation Gateway', 'trim|required');
		}
		if(isset($_POST['store_trust']) && $_POST['store_trust']!="")
		{
			$this->form_validation->set_rules('store_gateway', 'Store Gateway', 'trim|required');
		}
		if(isset($_POST['subscription_trust']) && $_POST['subscription_trust']!="")
		{
			$this->form_validation->set_rules('subscription_gateway', 'Subscription Gateway', 'trim|required');
		}

		if((isset($_POST['pooja_trust']) && $_POST['pooja_trust']!="") || (isset($_POST['donation_trust']) && $_POST['donation_trust']!="") || (isset($_POST['store_trust']) && $_POST['store_trust']!="") || (isset($_POST['subscription_trust']) && $_POST['subscription_trust']!=""))
		{
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("trust_error",1);
				redirect('ashramadmin/settings');
				return;
			}
		}

		$update = $this->ashrams_trust_accounts_model->updateTrustPaymentmode();
		if($update)
		{
			$this->session->set_flashdata("settings_success",1);
		}
		else
			$this->session->set_flashdata("settings_error",1);

		redirect('/ashramadmin/settings');
	}

	
	/**
	 * for exporting all Trusts based on Ashram
	 *@category ajax
	 *@return  void
	 */
	public function trustsExports()
	{
		$list=$this->ashrams_trust_accounts_model->exportTrusts();
		echo json_encode($list);
	}




	/**
	 * getting Trust 80g year note 
	 *@category ajax
	 *@return  void
	 */
	public function getTrust80gByTrustIdAndYear()
	{
		$data['flag']=0;
		$data['year_note'] = '';
		if(isset($_POST['trust_basic_id']) && $_POST['trust_basic_id']!="" && isset($_POST['trust_80g_year']) && $_POST['trust_80g_year']!="")
		{
			$yearNote = $this->ashrams_trust_accounts_model->getTrust80gByTrustIdAndYear($_POST['trust_basic_id'], $_POST['trust_80g_year']);
			if(empty($yearNote))
			{
				goto end;
			}
			$data['flag']=1;
			$data['year_note']=$yearNote->trust_80g_note;
		}
		end:
		echo json_encode($data);
	}


	/**
	 * Update Trust 80g year note 
	 *@category ajax
	 *@return  void
	 */
	public function updateTrust80gNote()
	{
		$data['flag']=0;
		if(isset($_POST['trust_basic_id']) && $_POST['trust_basic_id']>0 && isset($_POST['trust_80g_year']) && $_POST['trust_80g_year']!="" && isset($_POST['trust_80g_note']) && $_POST['trust_80g_note']!="")
		{
			$this->ashrams_trust_accounts_model->updateTrust80gNote($_POST['trust_basic_id'], $_POST['trust_80g_year'], $_POST['trust_80g_note']);
			$data['flag']=1;
		}
		end:
		echo json_encode($data);
	}


	/**
	 * getting Ashram 80g year note 
	 *@category ajax
	 *@return  void
	 */
	public function getAshram80gByAshramIdAndYear()
	{
		$data['flag']=0;
		$data['year_note'] = '';
		if(isset($_POST['ashram_id']) && $_POST['ashram_id']!="" && isset($_POST['ashram_80g_year']) && $_POST['ashram_80g_year']!="")
		{
			$yearNote = $this->ashrams_model->getAshram80gByAshramIdAndYear($_POST['ashram_id'], $_POST['ashram_80g_year']);
			if(empty($yearNote))
			{
				goto end;
			}
			$data['flag']=1;
			$data['year_note']=$yearNote->ashram_80g_note;
		}
		end:
		echo json_encode($data);
	}


	/**
	 * Update Ashram 80g year note 
	 *@category ajax
	 *@return  void
	 */
	public function updateAshram80gNote()
	{
		$data['flag']=0;
		if(isset($_POST['ashram_id']) && $_POST['ashram_id']>0 && isset($_POST['ashram_80g_year']) && $_POST['ashram_80g_year']!="" && isset($_POST['ashram_80g_note']))
		{
			$this->ashrams_model->updateAshram80gNote($_POST['ashram_id'], $_POST['ashram_80g_year'], $_POST['ashram_80g_note']);
			$data['flag']=1;
		}
		end:
		echo json_encode($data);
	}

	/**
	 * Update Ashram Year End Statement Data
	 *@category ajax
	 *@return  void
	 */
	public function updateAshramYearEndStatement($ashram_id=0)
	{
		$data['flag']=0;
		if(!$ashram_id)
		{
			$data['msg']="Invalid Ashram";
			goto end;
		}
		$ashramData=$this->ashrams_model->ashramData($ashram_id);
		if(empty($ashramData))
		{
			$data['msg']="No ashram found with provided ashram id";
			goto end;
		}
		$ashram_currencies=$this->currencies_model->getByAshram($ashram_id);
		$exist_currencies=array();
		foreach ($ashram_currencies as $ashram_currency)
		{
		    $exist_currencies[]=$ashram_currency['currency'];
		}
		foreach ($GLOBALS['currencies'] as $currency)
		{
			if( (is_single_currency_site && default_currency!=strtolower($currency['currency'])) || (!in_array(strtolower($currency['currency']), $exist_currencies)) )
	        { 
	            continue;
			}
			$this->form_validation->set_rules('trust_name_'.strtolower($currency['currency']), 'Trust Name', 'trim|required|min_length[6]|max_length[200]');
			$this->form_validation->set_rules('trust_address_'.strtolower($currency['currency']), 'Trust Address', 'trim|required|min_length[6]|max_length[1000]');
			$this->form_validation->set_rules('year_end_statement_text_'.strtolower($currency['currency']), strtoupper($currency['currency']).' Year End Statement Text', 'trim|required|min_length[6]|max_length[10000]');

			if(isset($_FILES['year_end_statement_image_'.strtolower($currency['currency'])]['name']) && $_FILES['year_end_statement_image_'.strtolower($currency['currency'])]['name']!='')
			{
				$allowed_file_types =   array('image/jpeg','image/jpg','image/png');
				$ext=pathinfo ($_FILES['year_end_statement_image_'.strtolower($currency['currency'])]['name'],PATHINFO_EXTENSION);
				if($_FILES['year_end_statement_image_'.strtolower($currency['currency'])]['size']==0 || $ext=='' || !in_array($_FILES['year_end_statement_image_'.strtolower($currency['currency'])]['type'],$allowed_file_types) ||
						$_FILES['year_end_statement_image_'.strtolower($currency['currency'])]['size']>(10*1024*1024))
				{
					$result['msg']="Invalid ".strtoupper($currency['currency'])." Year End Statement Logo";
					goto end;
				}
			}
		}

		if($this->form_validation->run() == FALSE)
		{
			$data['flag']=0;
			$data['msg']="Invalid request, Please check all the mandatory fields.";
			goto end;
		}

		$this->ashrams_model->updateAshramYearEndStatement($ashram_id);
		$data['flag']=1;
		$data['msg']="Year End Statement details updated successfully";

		end:
		echo json_encode($data);
	}

	public function trust_basic_details()
	{
		$views = array( 'ashrams/admin/list_trust_basic_details' );
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Basic Trust Details Listing");
	}

	public function list_trust_basic_details($excel=0)
	{
		$list=$this->ashrams_trust_accounts_model->listTrustBasicDetailsAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Ashrams Listing ajax request");
	}

	public function add_edit_trust_basic_details($id=0)
	{
		$trust_currency = '';
		if(is_numeric($id) && $id)
		{
			$trustBasicData=$this->ashrams_trust_accounts_model->trustBasicDataById($id);
			if(empty($trustBasicData))
			{
				$this->session->set_flashdata("trust_error",1);
				redirect('ashramadmin/trust_basic_details');
			}
			if(isset($trustBasicData->currency))
			{
				$trust_currency = strtolower($trustBasicData->currency);
			}
		}
		else
		{
			$trustBasicData=array();
		}

		if(isset($_POST["trust_name"]))
		{
			if(!isset($_POST['description']))
			{
				$this->session->set_flashdata("trust_error",1);
				if($id)
					redirect('ashramadmin/add_edit_trust_basic_details/'.$id);
				else
					redirect('ashramadmin/add_edit_trust_basic_details');
				return;
			}

			if(!$id)
			{
				$this->form_validation->set_rules('trust_currency', 'Trust Currency', 'trim|required');
				$trust_currency = strtolower($_POST['trust_currency']);
			}


			$this->form_validation->set_rules('trust_name', 'Trust Name', 'trim|required|min_length[3]|max_length[100]|checkTrustName['.$id.' || '.$trust_currency.']');
			$this->form_validation->set_rules('address', 'Trust Address', 'trim|required|min_length[6]|max_length[1000]');
			$this->form_validation->set_rules('description', 'Trust Description', 'trim|required|min_length[6]|max_length[1000]');
			$this->form_validation->set_rules('trust_footer', 'Trust Receipt Footer', 'trim|required|min_length[6]|max_length[200]');
			$this->form_validation->set_rules('contact_person', 'Contact Person', 'trim|required|min_length[3]|max_length[100]');
			
			

			if(isset($_FILES['trust_logo']['name']) && $_FILES['trust_logo']['name']!='')
			{
				$allowed_file_types =   array('image/jpeg','image/jpg','image/png');
				$ext=pathinfo ($_FILES['trust_logo']['name'],PATHINFO_EXTENSION);
				if($_FILES['trust_logo']['size']==0 || $ext=='' || !in_array($_FILES['trust_logo']['type'],$allowed_file_types) ||
						$_FILES['trust_logo']['size']>(10*1024*1024))
				{
					$this->session->set_flashdata("trust_error",1);
					if($id)
						redirect('ashramadmin/add_edit_trust_basic_details/'.$id);
					else
						redirect('ashramadmin/add_edit_trust_basic_details');
					return;
				}
			}

			if($this->form_validation->run() == FALSE)
			{
				echo 'error'; exit;
				$this->session->set_flashdata("trust_error",1);
				if($id)
					redirect('ashramadmin/add_edit_trust_basic_details/'.$id);
				else
					redirect('ashramadmin/add_edit_trust_basic_details');
				return;
			}
			$this->load->model("user/users_model");
			$this->load->model("ashrams/ashrams_trust_accounts_model");
			$saved=$this->ashrams_trust_accounts_model->saveTrustBasicDetails($id);
			if(!$saved)
			{
				$this->session->set_flashdata("trust_error",1);
				if($id)
					redirect('ashramadmin/add_edit_trust_basic_details/'.$id);
				else
					redirect('ashramadmin/add_edit_trust_basic_details');
				return;
			}
			if($id==0)
			{
				$this->session->set_flashdata("trust_created",1);
			}
			else
			{
				$this->session->set_flashdata("trust_saved",1);
			}
			redirect('ashramadmin/add_edit_trust_basic_details/'.$saved);
			
		}
		else
		{
			if($id!='' && (empty($trustBasicData)) )
			{
				redirect('ashramadmin/trust_basic_details');
			}
			$views = array('ashrams/admin/add_edit_trust_basic_details');
			$data = array('views'=>$views,'id'=>$id);
			$data['ashram_currencies']=$this->currencies_model->getByAshram($id);
			if(is_numeric($id) && $id)
			{
				$data['trustBasicData']=$trustBasicData;
			}
			$this->load->view(ADMIN_TEMPLATE,$data); 
		}
	}

	public function getTrustBasicDetails()
	{
		$data['flag'] = 0;
		if(isset($_POST['trust_basic_id']) && $_POST['trust_basic_id']>0)
		{
			$trustBasicData=$this->ashrams_trust_accounts_model->trustBasicDataById($_POST['trust_basic_id']);
			if(empty($trustBasicData))
			{
				$data['message'] = "No trust found";
				goto end;
			}
			if(!$trustBasicData->logo)
				$trustBasicData->logo = aws_s3_base_url."images/site_assets/global_site_images/no-image.png";
			else
				$trustBasicData->logo = aws_s3_base_url."images/trusts/trust_images/thumb_".$trustBasicData->logo;

			$data['trustBasicData'] = $trustBasicData;
			$data['flag'] = 1;
		}

		end:
		echo json_encode($data);
	}

///================================Newsletters ================================//
	
	public function newsletters()
	{
		$views = array( 'ashrams/admin/list_newsletters' );
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"User - Viewed newsletters page");
	}

	public function listnewsletters($excel=0)
	{
		$list=$this->ashram_newsletters_model->listNewsletters($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"User - Viewed newsletters ajax request");
	}

	public function mail_queue($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$newsletterData=$this->ashram_newsletters_model->newsletterData($id);
			if(empty($newsletterData))
			{
				$this->session->set_flashdata("newsletter_error",1);
				redirect("ashramadmin/newsletters");
			}
			if($newsletterData->ashram_id!=$this->session->userdata("ashramId"))
			{
				$this->session->set_flashdata("newsletter_error",1);
				redirect("ashramadmin/newsletters");
			}
			$views = array( 'ashrams/admin/list_newsletter_queue' );
			$data = array('views'=>$views);
			$data['newsletterData']=$newsletterData;
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
		else
		{
			$this->session->set_flashdata("newsletter_error",1);
			redirect('ashramadmin/newsletters');
		}
	}

	public function listqueue($id=0,$excel=0)
	{
		if(is_numeric($id) && $id)
		{
			$newsletterData=$this->ashram_newsletters_model->newsletterData($id);
			if(empty($newsletterData))
			{
				return;
			}
			if($newsletterData->ashram_id!=$this->session->userdata("ashramId"))
			{
				return;
			}
			$list=$this->newsletters_que_model->listQueue($newsletterData,$excel);
			echo json_encode($list);
		}
	}

	public function sms_queue($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$newsletterData=$this->ashram_newsletters_model->newsletterData($id);
			if(empty($newsletterData))
			{
				$this->session->set_flashdata("newsletter_error",1);
				redirect("ashramadmin/newsletters");
			}
			if($newsletterData->ashram_id!=$this->session->userdata("ashramId"))
			{
				$this->session->set_flashdata("newsletter_error",1);
				redirect("ashramadmin/newsletters");
			}
			$views = array( 'ashrams/admin/list_newsletter_sms_queue' );
			$data = array('views'=>$views);
			$data['newsletterData']=$newsletterData;
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
		else
		{
			$this->session->set_flashdata("newsletter_error",1);
			redirect('ashramadmin/newsletters');
		}
	}

	public function listsmsqueue($id=0,$excel=0)
	{
		if(is_numeric($id) && $id)
		{
			$newsletterData=$this->ashram_newsletters_model->newsletterData($id);
			if(empty($newsletterData))
			{
				return;
			}
			if($newsletterData->ashram_id!=$this->session->userdata("ashramId"))
			{
				return;
			}
			$list=$this->newsletters_sms_que_model->listQueue($newsletterData,$excel);
			echo json_encode($list);
		}
	}

	public function add_edit_newsletter($id=0)
	{
		if(!$this->session->userdata("ashramId"))
		{
			redirect("ashramadmin/newsletters");
		}
		if(isset($_POST["add_newsletter"]) || isset($_POST["send_newsletter"]))
		{

			if(!isset($_POST['country']) || !isset($_POST['content']) || !isset($_POST['age_from']) || !isset($_POST['age_to']))
			{
				$this->session->set_flashdata("newsletter_error",1);
				redirect('ashramadmin/add_edit_newsletter/'.$id);
			}
			$this->form_validation->set_rules('type', 'Type', 'trim|numeric|newsletterType');

			if($this->input->post("type")==1)
			{
				$this->form_validation->set_rules('subject', 'Email Subject', 'trim|required|min_length[6]|max_length[200]');
				$this->form_validation->set_rules('content', 'Content', 'trim|required|min_length[3]|max_length[200000]');
			}
			else if($this->input->post("type")==2)
			{
				$this->form_validation->set_rules('message', 'SMS Message', 'trim|required|min_length[6]|max_length[320]');
			}
			else if($this->input->post("type")==3)
			{
				$this->form_validation->set_rules('subject', 'Email Subject', 'trim|required|min_length[6]|max_length[200]');
				$this->form_validation->set_rules('message', 'SMS Message', 'trim|required|min_length[6]|max_length[320]');
				$this->form_validation->set_rules('content', 'Content', 'trim|required|min_length[3]|max_length[200000]');
			}

			$this->form_validation->set_rules('age_from', 'By Age', 'trim|numeric|checkAgeLimit|newsletterAgeFilter');
			$this->form_validation->set_rules('age_to', 'By Age', 'trim|numeric|checkAgeLimit|newsletterAgeFilter');
			$this->form_validation->set_rules('pooja_from_date', 'Pooja From Date', 'trim|valid_date');
			$this->form_validation->set_rules('pooja_to_date', 'Pooja To Date', 'trim|valid_date');
			$this->form_validation->set_rules('donation_from_date', 'Donation From Date', 'trim|valid_date');
			$this->form_validation->set_rules('donation_to_date', 'Donation To Date', 'trim|valid_date');
			$this->form_validation->set_rules('subscription_from_date', 'Subscription From Date', 'trim|valid_date');
			$this->form_validation->set_rules('subscription_to_date', 'Subscription To Date', 'trim|valid_date');
			$this->form_validation->set_rules('store_item_from_date', 'Store Item From Date', 'trim|valid_date');
			$this->form_validation->set_rules('store_item_to_date', 'Store Item To Date', 'trim|valid_date');


			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("newsletter_error",1);
				redirect('ashramadmin/add_edit_newsletter/'.$id);
				return;
			}
			if($id)
			{
				$newsletterData=$this->ashram_newsletters_model->newsletterData($id);

				if(empty($newsletterData))
				{
					$this->session->set_flashdata("newsletter_error",1);
					redirect("ashramadmin/newsletters");
				}
				if($newsletterData->ashram_id!=$this->session->userdata("ashramId"))
				{
					$this->session->set_flashdata("newsletter_error",1);
					redirect("ashramadmin/newsletters");
				}
				if($newsletterData->status!=1)
				{
					$this->session->set_flashdata("newsletter_error",1);
					redirect("ashramadmin/newsletters");
				}
			}
			$saved=$this->ashram_newsletters_model->save($id);
			
			if($saved)
			{
				if($id)
				{
					$this->session->set_flashdata("newsletter_saved",1);
				}
				else
				{
					$this->session->set_flashdata("newsletter_created",1);
				}
				// if(isset($_POST['send_newsletter']))
				// {
				// 	$this->ashram_newsletters_model->sendNewsletter($saved);
				// 	redirect('ashramadmin/view_newsletter/'.$saved);
				// 	return;
				// }
			}
			redirect('ashramadmin/add_edit_newsletter/'.$saved);
		}
		else
		{
		 	$views = array( 'ashrams/admin/add_edit_newsletter' );
		 	$data = array('views'=>$views,'id'=>$id);
		 	$data['countries']=$this->locations_model->getCountries();
		 	$data['ashramData']=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
		 	if($this->session->userdata("ashramId"))
		 	{
		 		$this->load->model('ashrams/poojas_model');
		 		$this->load->model('ashrams/poojas_categories_model');
		 		$this->load->model('ashrams/donations_model');
		 		$this->load->model('ashrams/donations_categories_model');
		 		$this->load->model('ashrams/subscriptions_model');
		 		$this->load->model('ashrams/subscriptions_categories_model');
		 		$this->load->model('ashrams/store_model');
		 		$this->load->model('ashrams/store_categories_model');
		 		$data['poojas']=$this->poojas_model->getByAshramId($this->session->userdata("ashramId"));
		 		$data['poojas_categories']=$this->poojas_categories_model->getCategoriesListByAshramId($this->session->userdata("ashramId"));
		 		$data['donations']=$this->donations_model->getByAshramId($this->session->userdata("ashramId"));
		 		$data['donations_categories']=$this->donations_categories_model->getCategoriesListByAshramId($this->session->userdata("ashramId"));
		 		$data['store_items']=$this->store_model->getByAshramId($this->session->userdata("ashramId"));
		 		$data['store_categories']=$this->store_categories_model->getCategoriesListByAshramId($this->session->userdata("ashramId"));
		 		$data['subscriptions']=$this->subscriptions_model->getByAshramId($this->session->userdata("ashramId"));
		 		$data['subscriptions_categories']=$this->subscriptions_categories_model->getCategoriesListByAshramId($this->session->userdata("ashramId"));
		 	}
		 	
			if($id)
			{
				$data['newsletterData']=$this->ashram_newsletters_model->newsletterData($id);
				if(empty($data['newsletterData']))
				{
					$this->session->set_flashdata("newsletter_error",1);
					redirect("ashramadmin/newsletters");
				}
				if($data['newsletterData']->field_userids!='')
			 	{
			 		$data['users']=$this->users_model->getUsersByIds(explode(",",$data['newsletterData']->field_userids));
			 	}
				if($data['newsletterData']->ashram_id!=$this->session->userdata("ashramId"))
				{
					$this->session->set_flashdata("newsletter_error",1);
					redirect("ashramadmin/view_newsletter/".$id);
				}
				if($data['newsletterData']->status==2)
				{
					redirect("ashramadmin/view_newsletter/".$id);
				}
			}
			if($this->currentUser->roles==1)
        	{
        		$data['ashrams']=$this->ashrams_model->getList();
        	}
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}

	public function view_newsletter($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$newsletterData=$this->ashram_newsletters_model->newsletterData($id);
			if(empty($newsletterData))
			{
				$this->session->set_flashdata("newsletter_error",1);
				redirect("ashramadmin/newsletters");
			}
			if($newsletterData->ashram_id!=$this->session->userdata("ashramId"))
			{
				$this->session->set_flashdata("newsletter_error",1);
				redirect("ashramadmin/newsletters");
			}
			if($newsletterData->status!=2)
			{
				redirect("ashramadmin/add_edit_newsletter/".$id);
			}
			$this->load->model('ashrams/poojas_model');
	 		$this->load->model('ashrams/poojas_categories_model');
	 		$this->load->model('ashrams/donations_model');
	 		$this->load->model('ashrams/donations_categories_model');
	 		$this->load->model('ashrams/subscriptions_model');
	 		$this->load->model('ashrams/subscriptions_categories_model');
	 		$this->load->model('ashrams/store_model');
	 		$this->load->model('ashrams/store_categories_model');

		 	$views = array('ashrams/admin/view_newsletter');
		 	$data = array('views'=>$views,'id'=>$id);
	 		$data['poojas']=$this->poojas_model->getByAshramId($newsletterData->ashram_id);
	 		$data['poojas_categories']=$this->poojas_categories_model->getCategoriesListByAshramId($newsletterData->ashram_id);
	 		$data['donations']=$this->donations_model->getByAshramId($newsletterData->ashram_id);
	 		$data['donations_categories']=$this->donations_categories_model->getCategoriesListByAshramId($newsletterData->ashram_id);
	 		$data['store_items']=$this->store_model->getByAshramId($newsletterData->ashram_id);
	 		$data['store_categories']=$this->store_categories_model->getCategoriesListByAshramId($newsletterData->ashram_id);
	 		$data['subscriptions']=$this->subscriptions_model->getByAshramId($newsletterData->ashram_id);
	 		$data['subscriptions_categories']=$this->subscriptions_categories_model->getCategoriesListByAshramId($newsletterData->ashram_id);
	 		if($newsletterData->field_userids!='')
		 	{
		 		$data['users']=$this->users_model->getUsersByIds(explode(",",$newsletterData->field_userids));
		 	}
		 	if($newsletterData->field_country!='')
		 		$data['countryData']=$this->locations_model->getCountryByCode($newsletterData->field_country);
			$data['newsletterData']=$newsletterData;
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
		else
		{
			$this->session->set_flashdata("newsletter_error",1);
			redirect("ashramadmin/newsletters");
		}
	}

	public function delete_newsletter($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$newsletterData=$this->ashram_newsletters_model->newsletterData($id);
			if(!empty($newsletterData) && $newsletterData->status==1 && $newsletterData->ashram_id==$this->session->userdata("ashramId"))
			{
				$r=$this->ashram_newsletters_model->delete($id,$newsletterData);
				if($r)
				{
					$data['flag']=1;
					$data['unique_id']=$newsletterData->unique_id;
				}
			}
		}
		echo json_encode($data);
	}

	public function resend($id=0,$qid=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id && is_numeric($qid) && $qid)
		{
			$newsletterData=$this->ashram_newsletters_model->newsletterData($id);
			if(empty($newsletterData))
			{
				goto end;
			}
			if($newsletterData->ashram_id!=$this->session->userdata("ashramId"))
			{
				goto end;
			}
			if($newsletterData->type==1)
			{
				$mailData=$this->newsletters_que_model->mailData($qid);
				if(empty($mailData) || $mailData->newsletter_id!=$id || $mailData->status==0)
				{
					goto end;
				}
				$r=$this->newsletters_que_model->resend($qid,$mailData);
				if($r)
				{
					$data['flag']=1;
					$data['email']=$mailData->mail_to;
				}
			}
			if($newsletterData->type==2)
			{
				$smsData=$this->newsletters_sms_que_model->smsData($qid);
				if(empty($smsData) || $smsData->newsletter_id!=$id || $smsData->status==0)
				{
					goto end;
				}
				$r=$this->newsletters_sms_que_model->resend($qid,$smsData);
				if($r)
				{
					$data['flag']=1;
					$data['email']=$smsData->to;
				}
			}
		}
		end:
		echo json_encode($data);
	}

	public function validate_users()
	{
		if($this->input->post("users_string")!='')
		{
			$users=$this->ashram_members_model->validateUsers($this->input->post("users_string"));
			header("Content-Type:application/json");
			echo json_encode($users);
		}
		else
		{
			header("Content-Type:application/json");
			json_encode(array());
		}
	}

	public function searchuser()
	{
		$query = (!empty($_POST['q'])) ? strtolower($_POST['q']) : null;
		 
		if (!isset($query)) {
		    die('Invalid query.');
		}
		 
		$status = true;
		$this->logaction->log($this->service,"Searched users with - ".$query);
		$usersData=$this->ashram_members_model->searchUsers($query);
		$resultUsers = [];
		foreach ($usersData as $oneUser)
		{
		    $oneUser['avatar']='';
		    if($oneUser['profilepic']!='')
		    {
			    $uname=$oneUser['uusername'];
			    $fletter=strtolower($uname[0]);
			    $path=sso_aws_s3_base_url."users_profiles/".$fletter."/".md5($oneUser['sso_user_id'])."/thumb50_".$oneUser['profilepic'];
			    if(file_get_contents($path))
			    {
			    	$oneUser['avatar']='<span class="avatar"><img src="'.$path.'"></span>';
			    }
			}
			if($this->input->post("type")=='users_newsletters')
			{
				$resultUsers[]=array("id"=>$oneUser['uid'],"text"=>$oneUser['firstname']." ".$oneUser['lastname']." (".$oneUser['uusername'].")");
			}
			else
				$resultUsers[] = $oneUser;
		}
		// Means no result were found
		if (empty($resultUsers)) 
		{
		    $status = false;
		}
		 
		header('Content-Type: application/json');
		 
		echo json_encode(array(
		    "status" => $status,
		    "error"  => null,
		    "data"   => array(
		        "user"      => $resultUsers
		    )
		));
	}

	public function getNewsletterParticipants($newsletter_id=0)
	{
		$data['flag']=1;
		$data['newsletterUsers']=$this->ashram_newsletters_model->getNewsletterParticipants($newsletter_id);
		echo json_encode($data);
	}

	public function sendNewsletter($id=0)
	{
		$data['flag']=0;
		if(!$this->session->userdata("ashramId"))
		{
			goto endstep;
		}
		$newsletterData=$this->ashram_newsletters_model->newsletterData($id);
		if(empty($newsletterData))
		{
			goto endstep;
		}
		if($newsletterData->ashram_id!=$this->session->userdata("ashramId"))
		{
			goto endstep;
		}
		if($newsletterData->status!=1)
		{
			goto endstep;
		}

		$this->ashram_newsletters_model->sendNewsletter($id);
		$data['flag']=1;

		endstep:
		echo json_encode($data);
	}

	public function testNewsletterSms($id=0)
	{
		$data['flag']=0;
		if(!$this->session->userdata("ashramId"))
		{
			goto endstep;
		}
		$newsletterData=$this->ashram_newsletters_model->newsletterData($id);
		if(empty($newsletterData))
		{
			goto endstep;
		}
		if($newsletterData->ashram_id!=$this->session->userdata("ashramId"))
		{
			goto endstep;
		}
		if($newsletterData->status!=1)
		{
			goto endstep;
		}
		if(!isset($_POST['test_sms_country_isd']) || $_POST['test_sms_country_isd']=="")
		{
			goto endstep;
		}
		if(!isset($_POST['test_sms_phone_number']) || $_POST['test_sms_phone_number']=="")
		{
			goto endstep;
		}

		if($GLOBALS['site_settings']['sms_service']==1)
    	{
			$recipient_to=$_POST['test_sms_country_isd'].$_POST['test_sms_phone_number'];
			$nData=array('to' => $recipient_to,
								'date' => date("Y:m:d H:i:s"),
								'newsletter_id' => $id,
								'user_id' => $this->currentUser->id
							);
			$this->smsDb=$this->load->database("sms",true,false);
			$this->smsDb->insert('sms_track_newsletter_a_'.$this->session->userdata("ashramId"),$nData);
			
			// $this->newsletters_sms_que_model->setId($this->session->userdata("ashramId"));
			// $this->newsletters_sms_que_model->triggerNewsletters();
			$data['flag']=1;
    	}

		endstep:
		echo json_encode($data);
	}

	public function testNewsletterEmail($id=0)
	{
		$data['flag']=0;
		if(!$this->session->userdata("ashramId"))
		{
			goto endstep;
		}
		$newsletterData=$this->ashram_newsletters_model->newsletterData($id);
		if(empty($newsletterData))
		{
			goto endstep;
		}
		if($newsletterData->ashram_id!=$this->session->userdata("ashramId"))
		{
			goto endstep;
		}
		if($newsletterData->status!=1)
		{
			goto endstep;
		}
		if(!isset($_POST['test_email']) || trim($_POST['test_email'])=="")
		{
			goto endstep;
		}

		if($GLOBALS['site_settings']['email_service']==1)
    	{
    		$nData=array('mail_to' => trim($_POST['test_email']),
							'mail_subject' => "[Newsletter] - ".$newsletterData->subject,
							'date' => date("Y:m:d H:i:s"),
							'newsletter_id' => $newsletterData->id,
							'user_id' => $this->currentUser->id
						);
    		$this->emailDb=$this->load->database("emails",true,false);
			$this->emailDb->insert('mail_track_newsletter_a_'.$this->session->userdata("ashramId"),$nData);
			
			// $this->newsletters_que_model->setId($this->session->userdata("ashramId"));
			// $this->newsletters_que_model->triggerNewsletters();
			$data['flag']=1;
    	}

		endstep:
		echo json_encode($data);
	}

	public function stopNewsletter($newsletter_id=0)
	{
		$data['flag']=0;
		if(!is_numeric($newsletter_id) && $newsletter_id)
		{
			goto endstep;
		}
		if(!$this->session->userdata("ashramId"))
		{
			goto endstep;
		}
		$newsletterData=$this->ashram_newsletters_model->newsletterData($newsletter_id);
		if(empty($newsletterData))
		{
			goto endstep;
		}
		if($newsletterData->ashram_id!=$this->session->userdata("ashramId"))
		{
			goto endstep;
		}
		$this->ashram_newsletters_model->stopNewsletterByNewsletterId($newsletter_id);
		$data['flag']=1;
		endstep:
		echo json_encode($data);
	}

}
?>