<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Articlesadmin extends CI_Controller 
{
	var $service='content';
    function __construct() 
	{
        parent::__construct();
		$this->load->model('content/articles_model');
		$this->load->model('content/articles_images_model');
		$this->load->model('content/articles_category_model');
		$this->load->model('category/categories_model');
		$this->currentUser=$this->session->userdata("admin_data");
		$this->categories_model->fetchCategories();
    }
	public function index()
	{
		$views = array( 'articles/admin/list' );
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Articles Listing");
	}

	public function listc($excel=0)
	{
		$list=$this->articles_model->listAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Articles Listing ajax request");
	}
	
	function add_edit_article ($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$articleData=$this->articles_model->articleData($id);
			if(empty($articleData))
			{
				$this->session->set_flashdata("article_error",1);
				redirect('articlesadmin');
			}
		}
		else
		{
			$articleData=array();
		}

		if(isset($_POST["save_article"]))
		{
			if(!isset($_POST['description']))
			{
				$this->session->set_flashdata("article_error",1);
				redirect('articlesadmin/add_edit_article/'.$id);
			}

			$this->form_validation->set_rules('name', 'Article Title', 'trim|required|min_length[6]|max_length[200]|articleNameCheck');
			$this->form_validation->set_rules('categories[]', 'Categories', 'checkCategories');
			$this->form_validation->set_rules('published_on', 'Publish Date', 'trim|required');
			$this->form_validation->set_rules('seo_keywords', 'SEO Keywords', 'trim|min_length[10]|max_length[500]');
			$this->form_validation->set_rules('seo_description', 'SEO Description', 'trim|min_length[10]|max_length[500]');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("article_error",1);
				redirect('articlesadmin/add_edit_article/'.$id);
				return;
			}
			$saved=$this->articles_model->save($id,$articleData);
			if($id==0)
			{
				$this->session->set_flashdata("article_created",1);
			}
			else
				$this->session->set_flashdata("article_saved",1);
			redirect('articlesadmin/add_edit_article/'.$saved);
			
		}
		else
		{
			if($id!='' && (empty($articleData)) )
			{
				redirect('articlesadmin');
			}
			$views = array('articles/admin/add_edit_article');
			$data = array('views'=>$views,'id'=>$id);
			if(is_numeric($id) && $id)
			{
				$data['articleData']=$articleData;
			}
			$this->load->view(ADMIN_TEMPLATE,$data); 
		}
	}

	function delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$articleData=$this->articles_model->articleData($id);
			if(empty($articleData))
			{
				goto end;
			}
			$r=$this->articles_model->delete($id,$articleData);
			if($r)
			{
				$data['flag']=1;
				$data['name']=$articleData->name;
				$this->logaction->log($this->service,"Admin - Article '".$articleData->name."' deleted - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}
	public function titlecheck($id=0)
	{
		if(isset($_POST['title']) && $_POST['title']!='')
		{
			$slug=url_title($this->general_model->filtertext($_POST['title']));
			if(strlen($slug)<6)
				echo 0;
			else
			{
				echo 1;
			}
		}
	}
	public function article_validate($aid=0,$pid=0)
	{
		if(is_numeric($aid) && is_numeric($pid) && $pid)
		{
			if($aid==$pid)
			{
				echo 2;
			}
			else
			{
				$parentArticleData=$this->articles_model->articleData($pid);
				if(!empty($parentArticleData))
				{
					echo $parentArticleData->name."<br>".date("d M Y",strtotime($parentArticleData->published_on));
				}
				else
					echo 0;
			}
		}
		else
			echo 0;
	}
}
?>