<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class AdminFiles extends CI_Controller 
{
	var $currentUser='';
	var $service='files';
    function __construct() 
	{
        parent::__construct();
		$this->load->library("userutil");
		if($this->session->userdata('id'))
		{
			$this->currentUser=$this->session->userdata("admin_data");
		}
		else if($this->session->userdata('user_id'))
		{
			$this->currentUser=$this->session->userdata("user_data");
		}
		$this->load->model("user/users_model");
		$this->load->model("files/files_model");
    }
    function index()
	{
		$views = array('files/list');
		$data = array('views'=>$views);
		if($this->currentUser->admin==1)
			$this->load->view(ADMIN_TEMPLATE,$data);
		else
			$this->load->view(USER_TEMPLATE,$data);
	}
	public function getfiles()
	{
		$list=$this->files_model->getFiles();
		echo json_encode($list);
	}
	public function getsharedfiles()
	{
		$list=$this->files_model->getSharedFiles();
		echo json_encode($list);
	}
	function upload()
	{
		$exts=$GLOBALS['site_settings']['blocked_file_types'];
		$excludedExtensions=explode("|",$exts);

		$json['files']=[];
		foreach ($_FILES['files']['name'] as $key => $file) 
		{
			$ext=pathinfo ($_FILES['files']['name'][$key],PATHINFO_EXTENSION);

			if($_FILES['files']['size'][$key]==0)
			{
				$json['files'][] = array(
	            'name' => $file,
	            'size' => $_FILES['files']['size'][$key],
	            'type' => $_FILES['files']['type'][$key],
	            'error' => "Invalid File Size",
	            'status'=>0
	        	);
			}
			else if($_FILES['files']['size'][$key]>(5*1024*1024))
			{
				$json['files'][] = array(
	            'name' => $file,
	            'size' => $_FILES['files']['size'][$key],
	            'type' => $_FILES['files']['type'][$key],
	            'error' => "File Size exceeded 5 MB",
	            'status'=>0
	        	);
			}
			else if($ext=='' || in_array($ext,$excludedExtensions))
			{
				$json['files'][] = array(
	            'name' => $file,
	            'size' => $_FILES['files']['size'][$key],
	            'type' => $_FILES['files']['type'][$key],
	            'error' => "Extension not allowed",
	            'status'=>0
	        	);
			}
			else
			{	
        		$json['files'][0]=$this->files_model->uploadFile();
        		$json['files'][0]['name']=$file;
        		$json['files'][0]['type']=$_FILES['files']['type'][$key];
        		$json['files'][0]['size']=$_FILES['files']['size'][$key];
        		$json['files'][0]['status']=1;
        	}
		}
		echo json_encode($json);
	}
	function delete($fileId=0)
	{
		$data['flag']=0;
		if(is_numeric($fileId) && $fileId)
		{
			$fileData=$this->files_model->fileData($fileId);
			if(empty($fileData))
			{
				goto end;
			}
			if($fileData->user_id!=$this->currentUser->id)
			{
				goto end;
			}
			$r=$this->files_model->delete($fileData);
			if($r)
			{
				$data['flag']=1;
				$data['filename']=$fileData->filename;
			}
		}
		end:
		echo json_encode($data);
	}
	public function updatedescription()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|max_length[500]');
    	$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
    	if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$this->files_model->updateDescription($_POST['pk'],$_POST['value']);
		echo 1;
	}
	public function sharepop($fileId=0)
	{
		if(is_numeric($fileId) && $fileId)
		{
			$fileData=$this->files_model->fileData($fileId);
			if(empty($fileData))
			{
				echo 0;
				return;
			}
			if($fileData->user_id!=$this->currentUser->id)
			{
				echo 0;
				return;
			}
			$data['id']=$fileId;
			$data['fileData']=$fileData;
			$data['users']=array();
			if($fileData->shared_user_ids!='')
			{
				$userIds=array_filter(explode(",",$fileData->shared_user_ids));
				foreach ($userIds as $userId)
				{
					$tempUserData=$this->users_model->userData($userId);
					if(!empty($tempUserData))
					{
						$data['users'][$userId]=array("id"=>$userId,"name"=>$tempUserData->firstname." ".$tempUserData->lastname,"username"=>$tempUserData->username);
					}
				}
			}
			$this->load->view("files/share",$data);
		}
		else
			echo 0;
	}
	public function share($fileId=0)
	{
		if(is_numeric($fileId) && $fileId)
		{
			$fileData=$this->files_model->fileData($fileId);
			if(empty($fileData))
			{
				echo 0;
				return;
			}
			if($fileData->user_id!=$this->currentUser->id)
			{
				echo 0;
				return;
			}
			$this->files_model->share($_POST['users'],$fileData);
			echo 1;
		}
		else
			echo 0;
	}
	public function checkshare($fileId=0)
	{
		if(is_numeric($fileId) && $fileId)
		{
			$fileData=$this->files_model->fileData($fileId);
			if(empty($fileData))
			{
				echo 0;
				return;
			}
			if($fileData->user_id!=$this->currentUser->id)
			{
				echo 0;
				return;
			}
			if($fileData->shared_user_ids!='')
				echo 1;
		}
		else
			echo 0;
	}
	public function searchuser()
	{
		$query = (!empty($_GET['q'])) ? strtolower($_GET['q']) : null;
		if (!isset($query)) {
		    die('Invalid query.');
		}
		$status = true;
		$usersData=$this->users_model->searchUsers($query,2);
		$resultUsers = [];
		$c=0;
		foreach ($usersData as $oneUser)
		{
			if($oneUser['uid']==$this->currentUser->id)
				continue;
			$resultUsers[$c]['id'] = $oneUser['uid'];
			$resultUsers[$c]['name'] = $oneUser['uusername'].", ".$oneUser['firstname']." ".$oneUser['lastname'];
			$c++;
		}
		echo json_encode($resultUsers);
	}
	public function download($fileId=0)
	{
		$flag=0;
		if(is_numeric($fileId) && $fileId)
		{
			$fileData=$this->files_model->fileData($fileId);
			if(empty($fileData))
			{
				goto end;
			}
			$sharedWith=array();
			if($fileData->shared_user_ids!='')
			{
				$sharedWith=array_filter(explode(",",$fileData->shared_user_ids));
			}
			if($fileData->user_id==$this->currentUser->id || in_array($this->currentUser->id,$sharedWith))
			{
				$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
				
				$amazonUri="adminfiles/".md5($fileData->user_id)."/".$fileData->filename;
				header("Cache-Control: public");
		        header("Content-Disposition: attachment; filename=".$fileData->filename);
				$obj=$this->s3->getObject(aws_s3_bucket_name,$amazonUri);
				echo $obj->body;
				return;
			}
		}
		end:
		if($flag==0)
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}
}
?>