<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Admin extends CI_Controller
{
	var $logtrack='';
    function __construct()
    {
        parent::__construct();
		$this->logtrack=$this->load->database("site_services",true);
		$this->currentUser=$this->session->userdata("admin_data");
	}

    public function index() 
	{
        $data = array();
        $this->load->view(ADMIN_TEMPLATE,$data);  
    }
	
    public function loginhistory()
    {
        $this->load->model('loginhistory_model','hist', TRUE);
        $data['query']=$this->hist->user_login_history();
        $data["views"] = array( 'admin/loginhistory' );
    	$this->load->view('admin/admin_template',$data);
    }
	 
	public function switchadmin()
	{
		$this->session->set_userdata('ashram_id',$_POST['aid']);
	}
	
	public function getchats()
	{
		$this->load->model('chatbox_model');
		$res=$this->chatbox_model->getChatsByUser();
		$res['current_user']=$this->currentUser->id;
		echo json_encode($res);
	}
	public function postchat()
	{
		$this->load->model('chatbox_model');
		$total=$this->chatbox_model->getTotalChatsToday($this->currentUser->id);
		if($total==5)
		{
			echo json_encode(array("flag"=>2,"count"=>0));
			return;
		}
		$this->chatbox_model->postChat($this->currentUser->id);
		$res=$this->chatbox_model->getChatsByUser();
		$res['current_user']=$this->currentUser->id;
		echo json_encode($res);
	}
	public function markSpam($mid=0)
	{
		$this->load->model('chatbox_model');
		$res=$this->chatbox_model->markSpam($mid,$this->currentUser->id);
		echo json_encode($res);
	}
	public function deletemessage($mid=0)
	{
		$this->load->model('chatbox_model');
		$res=$this->chatbox_model->deleteMessage($mid,$this->currentUser->id);
		echo json_encode($res);
	}

	public function change_password()
	{
		$views =array( 'users/admin/change_password');
		$data['views'] = $views;
		$this->load->view(ADMIN_TEMPLATE,$data);
    }

    public function update_pass() 
	{
		$this->form_validation->set_rules('current_password', 'Current Password', 'trim|required|min_length[8]|max_length[50]');
		$this->form_validation->set_rules('new_password', 'New Password', 'trim|required|min_length[8]|max_length[50]');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		
		if(trim($_POST['new_password'])==trim($_POST['current_password']))
		{
			echo 3;
			exit(0);
		}
		$resp=$this->users_model->updatePassword($this->currentUser->id,$_POST['current_password'],$_POST['new_password']);
		echo $resp;
	}
}
?>