<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| app_constants.php - dev.trinitydyc.org
*/

/*
|--------------------------------------------------------------------------
| Display Debug backtrace
|--------------------------------------------------------------------------
|
| If set to TRUE, a backtrace will be displayed along with php errors. If
| error_reporting is disabled, the backtrace will not display, regardless
| of this setting
|
*/

/* Constants listing sequence:
|
| 1. Global settings
| 
| 2. Base website settings
| 
| 3. Module settings
| 
| 4. Payment Gateway settings
| 
| 5. Third party service settings
| 
| 6. SSO settings
| 
| 7. Web & API service settings
|
*/

define('global_site_flag', 7); //Global site flag defines specific site folder to pick respective files from

/*
| site1 - dattapeetham.org (devdp)(datta)
| site2 - blrhanuman.org (devblrh)(blrh)
| site3 - sgsashrams.org (devsgsa)(sgsa)
| site4 - sevas.yogasangeeta.org (dsyogas)(syogas)
| site5 - sgsmedia.org (devsgsm)(sgsm)
| site6 - sevas.dycusa.org (devsdyc)(sdycusa)
| site7 - trinitydyc.org (devtdyc)(tdyc)
| site8 - sgsveda.dattapeetham.org (devsvdp)(sgsvdp)
| site9 - dattaretreatcenter.org (devdrc)(drc)
| 
| Site paths to check and edit when required:
| 
| /public_html/homepage_assets/site_1
| All front page/index page images are uploaded to this folder
| 
| /public_html/site_theme/site_1/theme_v361
| Site theme folder is maintained here
| 'admin_fonts' and other general 'fonts' will be called in each site as required and they need to be uploaded to the folders accordingly
| 
| /public_html/application/views/common/admin/dashboards/site_1
| Admin level dashboard files are placed in this folder
| 
| /public_html/application/views/common/admin/sidebars/site_1
| Admin level side menu files are placed in this folder
| 
| /public_html/application/views/common/user
| User level dashboard and side menu files are placed in this folder
| 
| /public_html/application/views/common/public
| Public level both top menus, footer, front page, internal sidebar, frontpage sidebar files are placed in this folder
| 
| Write a migration to Add site flag in both SSO DB 'users' table and individual domain Main DB 'users' tables
| Example: ALTER TABLE `users` ADD `site_flag_4` INT(4) NULL DEFAULT NULL AFTER `site_flag_5`;
|
| Add partner site in SSO DB (in datta_id_partner_sites table)
| INSERT INTO `datta_id_partner_sites` (`id`, `site_flag`, `partner_site_name`, `partner_site_url`, `location`, `allow_ip`, `auth_token`, `status`, `mobile_status`) VALUES (NULL, '5', 'SGS Media', 'https://dev.sgsmedia.org', 'Mysore, India', '', 'ccxxzcxcxce3x', '1', '0');
| 
| Add domain_sso user in domain DB users. Then grant SSO DB access to domain_sso user as root login
| At the MYSQL prompt run below commands:
| 
| To add user for access to database:
| mysql> GRANT ALL PRIVILEGES ON did_sso_globalusers.* TO 'syogas_sso'@'localhost';
| 
| To commit changes:
| mysql> FLUSH PRIVILEGES;
| 
| To check Grants for user on localhost:
| mysql> SHOW GRANTS FOR syogas_sso@localhost;
| 
*/


//==================== 1. Global settings ====================//

//===== https to https redirection =====//
$protocol='http';
if(isset($_SERVER['HTTPS']) && $_SERVER['HTTPS']=='on')
$protocol='https';
//===== https to https redirection =====//

define('meta_name_content', 'Jagadguru Datta Peethadhipathi His Holiness Sri Sri Sri Ganapathy Sachchidananda Swamiji, His Holiness Sri Datta Vijayananda Teertha Swamiji, Trinity Datta Yoga Center, Mysore, India, Lord Dattatreya, Datta Parampara');
define('meta_description_content', 'trinitydyc.org | Trinity Datta Yoga Center, Mysore, India official website');

define('site_short_name', 'TRINITY DYC');
define('site_name_string1','Trinity Datta Yoga Center');
define('display_site_name','Trinity Datta Yoga Center');
define('short_ashram_name', 'SGS Ashrama');
define('registered_from', 'trinitydyc');
define('registered_site', 'trinitydyc');
define('theme_folder_name','theme_v361');
define('page_title','Trinity Datta Yoga Center');

defined('SHOW_DEBUG_BACKTRACE') OR define('SHOW_DEBUG_BACKTRACE', TRUE);
define('FRONTEND_TEMPLATE','common/public/template');
define('ADMIN_TEMPLATE','common/admin/template');
define('ACCESS_TEMPLATE','common/admin/access_template');
define('USER_TEMPLATE','common/user/template');

$GLOBALS['currencies'][]=array('currency'=>'INR','symbol'=>'₹','min'=>'1','max'=>'500000','color'=>'black');
$GLOBALS['currencies'][]=array('currency'=>'USD','symbol'=>'$','min'=>'1','max'=>'10000','color'=>'red');

define('contact_latitude',12.285443);
define('contact_longitude',76.657886);
//==================== 1. Global settings ====================//



//==================== 2. Base website settings ====================//
// For additional settings check Ashram settings page: https://dev.trinitydyc.org/ashramadmin/settings

define('current_env', 'dev');

//===== Default ashram settings =====//
define('default_ashram_id',1); // Default ashram ID is 4 for DattaPeetham website
define('default_currency','usd');
define('default_ashram_name','Trinity Datta Yoga Center');
define('is_single_ashram_site',0); // (1 means single ashram, 0 means multiple ashrams)
define('is_single_currency_site',0); // (1 means single currency, 0 means multiple currencies) and default currency will be the currency for the single currency site
//===== Default ashram settings =====//

//define('server_name', 'li590-208.members.linode.com');
define('server_name', 'dpdev.linode.com');
define('server_ip', '192.155.93.208');
define('base_domain','dev.trinitydyc.org');
define('base_url',$protocol.'://dev.trinitydyc.org/');
define('URL_PREFIX', '/');
define('db_prefix','devtdyc_');
define('email_domain','@dev.trinitydyc.org');
define('no_email_domain','@useraccounts.trinitydyc.org');

//===== Open SSL encryption used for User stuff =====//
define('open_ssl_secret_key','DPDEV$secretkey$2K01');
define('open_ssl_key',hash('sha256', open_ssl_secret_key));
define('open_ssl_encrypt_method','AES-256-CBC');
define('open_ssl_secret_iv','DPDEV$secretiv$2K01');
define('open_ssl_iv',substr(hash('sha256', open_ssl_secret_iv), 0, 16));
//===== Open SSL encryption used for User stuff =====//

define('excel_reports_path',$_SERVER['DOCUMENT_ROOT'].'/site_services/excel_reports/');
define('excel_reports_exire_period','15 Days');

define('trademark_start_year', '2015');

//==================== 2. Base website settings ====================//



//==================== 3. Module settings ====================//

//===== User module settings =====//
define('special_login_users',array('bajidotwork@gmail.com','sekhardotwork@gmail.com','umadotwork@gmail.com')); //Special Users enabled for login, when User Login is disabled
//===== User module settings =====//

//===== Ashram module settings =====//
define('ashram_mismatch_order_emails', array('bajidotwork@gmail.com','pavandotwork@gmail.com')); //Send email report for mismatch ashram Orders CRON
//===== Ashram module settings =====//

//===== Orders module settings =====//
define('orders_email_cc','pavansgs9@gmail.com');
define('orders_email_cc_2','pavansgs9@gmail.com');
define('max_order_file_downloads',3);
define('pdf_header','Datta Peetham, Mysore');
define('receipt_office_accounts_footer','Office Accounts<br>SGS Ashrama<br>Mysore, India');
define('financial_year_start_month_date','04-01'); //INR financial year start month date
define('financial_year_end_month_date','03-31'); //INR financial year end month date
//===== Orders module settings =====//

//===== Vedoktashanti Poojas module settings =====//
define('vedoktashanti_admin_email','pavandotwork@gmail.com');
define('vedoktashanti_admin_email_cc','umadotwork@gmail.com');
define('vedoktashanti_cc_emails',array('bajidotwork@gmail.com','pavansgs9@gmail.com'));
//===== Vedoktashanti Poojas module settings =====//

//===== Vishwashanti Pada Yatra 2022 =====//
define('vishwashantipadayatra2022_full_donation_ids',array('27','29'));  //array('1','2','3')
define('vishwashantipadayatra2022_donation_ids',array('27','29'));
define('vishwashantipadayatra2022_form_days',array('2022-01-21','2022-01-22','2022-01-23','2022-01-24','2022-01-25','2022-01-26','2022-01-27','2022-01-28'));
define('vishwashantipadayatra2022_public_display_secret_key','kwx6kYOVP7PWcbc7dmoUPdwwB2iM8tDk');
define('public_donations_allowed_ashrams',array('21')); // Allowed Ashram IDs for public donations display. array('1','2')
//===== Vishwashanti Pada Yatra 2022 =====//

//===== Shodasha Datta Kshetra Pada Yatra =====//
define('shodasha_datta_kshetra_pada_yatra_donation_ids',array('37','38'));  //array('1','2','3')
define('shodasha_datta_kshetra_pada_yatra_form_days',array('2022-11-14','2022-11-15','2022-11-16'));  //array('2022-11-06','2022-11-07')
define('shodasha_datta_kshetra_pada_yatra_public_display_secret_key','dfr6LHFSGF7PWcbc7dmJHFJHB2iM8tKG');
//===== Shodasha Datta Kshetra Pada Yatra =====//

//===== 5th Generation Devotees =====//
define('fifthgendevotees_public_display_secret_key','cvW9CWgwr2m8fuE59qXOwq0tAQfFG1q4');
//===== 5th Generation Devotees =====//

//===== TechSupport module settings =====//
define('techsupport_admin_email','pavandotwork@gmail.com');
define('techsupport_admin_email_cc','umadotwork@gmail.com');
define('techsupport_cc_emails',array('bajidotwork@gmail.com','pavansgs9@gmail.com'));
define('feedback_contact_numbers','+19404359433 (WhatsApp, Telegram, iMessage)<br>+916309654754 (WhatsApp, Telegram, iMessage)<br><Br>');
define('techsupport_sendto_emails',array('sekhardotwork@gmail.com','bajidotwork@gmail.com','umadotwork@gmail.com','pavandotwork@gmail.com')); //TechSupport request forward to Email IDs
//===== TechSupport module settings =====//

//===== Contact module settings =====//
define('contact_admin_email','pavandotwork@gmail.com');
define('contact_admin_email_cc','bajidotwork@gmail.com,umadotwork@gmail.com,pavansgs9@gmail.com');
//===== Contact module settings =====//

//===== Forms module settings =====//
//define( 'ALLOW_DOWNLOAD', FALSE );
//define( 'BASE_DIR', __DIR__ );
//define( 'SAVED_FORMS_DIR', APPPATH . 'third_party/multipurposelibrary/saved-forms/' );
//define( 'ASSETS_DIR', BASE_DIR . '/formassets/' );
//define( 'TEMP_STORAGE', APPPATH . 'third_party/multipurposelibrary/saved-forms/temp_storage/' );
//define( 'DEMO_URL', 'http://multi-purpose-form-generator-v2.thewebfosters.com' );
//define( 'INCLUDE_COMMON_RESOURCES_IN_DOWNLOAD', TRUE );
//define( 'ALLOW_DOWNLOAD', TRUE );
//define( 'RESOURCE_VERSION', 1 );
//===== Forms module settings =====//

//==================== 3. Module settings ====================//



//==================== 4. Payment Gateway settings ====================//

//===== PayPal gateway settings =====//
// define('payflow_url', 'https://pilot-payflowpro.paypal.com');
//===== PayPal gateway settings =====//

//===== Razorpay gateway settings =====//
define('razorpay_failed_tx_report_emails',array('bajidotwork@gmail.com','pavandotwork@gmail.com'));
define('razorpay_webhook_secret_key', 'GfiggfbpJhwRu2FFkFao8euaisD9GvgS'); // CodeIgniter Encryption Keys - Can be used for any other 256-bit key requirement.

//===== Razorpay gateway settings =====//

//===== Stripe gateway settings =====//
define('stripe_webhook_secret_key_inr', 'whsec_FTydV4GEz9Q9pBPZcsxKMYqaWre3Twkb');
define('stripe_webhook_secret_key_usd', 'whsec_6ZPCbcDwLXqzQfqbQ09Ps81GFPwP8GWV');
//===== Stripe gateway settings =====//

//===== PayU gateway settings =====//
// define('payu_url', 'https://test.payu.in');
// define('payu_get_url', 'https://test.payumoney.com');
// define('payu_auth_key', 'lwUVQfcRt3qsWST0+yXpEbeKnNB62L050/HaJYlK+54=');
//===== PayU gateway settings =====//

//==================== 4. Payment Gateway settings ====================//



//==================== 5. Third party service settings ====================//

//===== Amazon AWS S3 SSO Global Users Settings to push files =====//
define('sso_aws_s3_base_url','https://dev-dattaid.s3.amazonaws.com/');
define('sso_aws_s3_bucket_name','dev-dattaid');
define('sso_aws_s3_access_key','AKIA2SJX4WVVF2OSE7WO');
define('sso_aws_s3_secret_key','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');
//===== Amazon AWS S3 SSO Global Users Settings to push files =====//

//===== Amazon AWS S3 settings to push files =====//
define('aws_s3_base_url','https://dev-trinitydyc.s3.amazonaws.com/');
define('aws_s3_bucket_name','dev-trinitydyc');
define('aws_s3_access_key','AKIA2SJX4WVVF2OSE7WO');
define('aws_s3_secret_key','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');
//===== Amazon AWS S3 settings to push files =====//

//===== Amazon AWS SES settings to send emails =====//
define('aws_ses_access_key','AKIA2SJX4WVVO3WSKJVO');
define('aws_ses_secret_key','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');
// The aws_ses_configuration_set constant value will need to be populated from AWS SES configuration set
define('aws_ses_configuration_set','devdp-ses-sms-notifications');
define('bounce_count_validation',2);
define('aws_ses_email_batch',1000);
define('aws_ses_emails_sent_per_second',50);
define('aws_ses_emails_batch_delay_microseconds',10000000);
//===== Amazon AWS SES settings to send emails =====//

//===== India SMS - settings using AWS SNS =====//
define('india_aws_sns_sms_region','us-east-1');
define('india_aws_sns_sms_access_key','AKIA2SJX4WVVNE6FSS6P');
define('india_aws_sns_sms_secret_key','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');
define('india_aws_sns_sms_senderID','DATTAAP');//Up to 11 alphanumeric characters, including at least one letter and no spaces.
//===== India SMS - settings using AWS SNS =====//

//===== All Other countries except India SMS - settings using AWS SNS =====//
define('other_countries_aws_sns_sms_region','us-east-1');
define('other_countries_aws_sns_sms_access_key','AKIA2SJX4WVVNE6FSS6P');
define('other_countries_aws_sns_sms_secret_key','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');
define('other_countries_aws_sns_sms_senderID','DATTAAP');//Up to 11 alphanumeric characters, including at least one letter and no spaces.
//===== All Other countries except India SMS - settings using AWS SNS =====//

//===== SMS additional settings using AWS SNS =====//
define('sms_fail_count_validation', 2);
define('aws_sns_sms_batch',5000);
define('aws_sns_sms_sent_per_second',50);
define('aws_sns_sms_batch_delay_microseconds',1000000);
//===== SMS additional settings using AWS SNS =====//

//===== Linode S3 settings =====//
define('linode_s3_url', 'https://us-east-1.linodeobjects.com/');
define('linode_s3_bucket', 'dev-trinitydyc');
//===== Linode S3 settings =====//

//===== Plivo SMS settings =====//
//define('plivo_base_url','https://api.plivo.com/v1/Account/MAOGM4MMQ5NZGXMGE0NM/');
//define('plivo_auth_id','MAOGM4MMQ5NZGXMGE0NM'); //https://console.plivo.com/dashboard/ (We can see this ID in this URL)
//define('plivo_auth_token','ODhjNDJlZDAwNzk0ZTg4MGFhODZiMzQyZTJjMWU1');
//Token can be seen in dashboard: https://console.plivo.com/dashboard/
//define('plivo_number','+19809999971');
//define('plivo_senderid','DATTAP');
//===== Plivo SMS settings =====//

//===== Text Local SMS settings =====//
//define('textlocal_username','trinitydyc.org@gmail.com');
//define('textlocal_hash','d67d5c5bfd5b2698f28ace566a5623b670672e64eef9f5ab2e1e5942f473dccc');
//===== Text Local SMS settings =====//

//===== Apple accounts =====//
define('apple_accounts','1097382754,549092019');
//===== Apple accounts =====//

//===== Google analytics account =====//
define('google_analytics_id','UA-84395637-1');
//===== Google analytics account =====//

//===== OneSignal mobile app push notification settings =====//
define('one_signal_api_end_point','https://onesignal.com/api/v1/');
define('one_signal_app_id','4da93cde-7c53-482e-a910-b8d4428dd25d');
define('one_signal_api_key','ZGY3ZjJhNzUtOWVmNC00NDFiLWIyMzAtN2M4NmRhMDcyNDQ5');
//===== OneSignal mobile app push notification settings =====//

//==================== 5. Third party service settings ====================//



//==================== 6. SSO settings ====================//

//===== Google SSO Login & Map API settings =====//
define('google_client_id','1063140238507-5blcce0p5kpceejgt7jg05gda8rdhsoe.apps.googleusercontent.com');
define('google_client_secret','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');
define('google_api_key','AIzaSyAQT45Meo1zeGS9OQpC7zzmWDGcxttlZ9E');
//===== Google SSO Login & Map API settings =====//

//===== Facebook SSO Login API settings =====//
define('fb_client_id','970873827580586');
define('fb_client_secret','0a744ecce14a9158f6990b08ee492d8e');
//===== Facebook SSO Login API settings =====//

//===== Microsoft SSO Login API settings =====//
define('msdn_client_id','44102a26-911c-4dd6-a6bb-ff28e5571af4');
define('msdn_client_secret','z688Q~LUD09bv6-ZQV0Y0WoXPS64QBNmJj~Txaka');
//===== Microsoft SSO Login API settings =====//

//===== Yahoo SSO Login API settings =====//
//define('yahoo_client_id','dj0yJmk9QjJpaTI5bjhCd3BIJmQ9WVdrOVNsZE5TbkZCTldNbWNHbzlNQS0tJnM9Y29uc3VtZXJzZWNyZXQmeD0xMw--');
//define('yahoo_client_secret','8cffe7ff21473b063f4107326b3eb704824d9414');
//===== Yahoo SSO Login API settings =====//

//==================== 6. SSO settings ====================//



//==================== 7. Web & API service settings ====================//

//===== Appji app API settings =====//
define('appji_ashram_id',5); // 0-No ashram is assigned to appji / if number is given that is ashram id
define('appji_donation_id',8); // 0-No donation is assigned to appji / if number is given that is donation item_id
define('appji_subscription_id',15); // 0-No subscription is assigned to appji / if number is given that is subscription item_id
//===== Appji app API settings =====//

//===== Datta Peetham mobile app API restriction settings =====//
define('shukavana_poojas',array(1,3,4));
define('shukavana_donations',array(1,2,3,4));
//===== Datta Peetham mobile app API restriction settings =====//

//===== DattaPeetham mobile app keys =====//
//define('mobile_app_client_id','devmobile');
//define('mobile_app_client_secret','0WfghfgdfdfgxzcaXcXz');
//===== DattaPeetham mobile app keys =====//

//===== DattaPeetham mobile app service to bypass regular login =====//
//Mobile App service to bypass regular website login using social login authentication credentials
//Recommended to change it every one month for security purposes
//define('dp_api_admin_bypass_key','123hUwKYLuOOaBx4AtFN2iyn123');
//===== DattaPeetham mobile app service to bypass regular login =====//

//===== Youtube PROD API keys =====//
define('youtube_api_key','AIzaSyAH_N-yGNia_QSyKP3YUsF-C0iLPjHUtJk');
//===== Youtube PROD API keys =====//

//===== Vimeo API keys =====//
define('vimeo_access_token','bb338b94fa743196d641afa60147568b');
//===== Vimeo API keys =====//

//===== Facebook API to Post & Read from Facebook account =====//
//define('fb_app_id','704803166315994');
//define('fb_app_secret','055cbdd36ede9b61bde1cf4aebc27bd2');
//define('fb_access_token','CAAKBA8ZAdZAdoBAAZAfvKDETJRVRCZByNFQvk7W4xis0JIceYbR1hmJ17cef41pFA698CN6YaAXym8bALPXMZANZBSCUVAPl0ZBGv4YBRZAeG3apSHErriN2kaaae41FmZAyZBIbkaLDfDDdH001K0HOiDZB4D1C5RTU2XGZCPAX0Y1WhYTQjUGtRpksa8QjG5W5pi9CZASb3nYUefj4UcFPDVZBOZC');
//define('fb_page_id','173229973449');
//===== Facebook API to Post & Read from Facebook account =====//

//==================== 7. Web & API service settings ====================//


//==================== 8. Mobile App One Signal(for notifications) =================//
define('mobile_one_signal_app_id' ,'e4fc5a8c-c3ac-4028-a068-86c0b4037e24');
define('mobile_one_signal_api_key' ,'NGJmZGUwOWUtZjhiOS00Yzg0LTllMmItNGMzYjE1N2Y2ODM1');
//==================== 8. Mobile App One Signal(for notifications) =================//

// ================= API Related Constants ============= //
define('api_auth_token_expires' ,1); //This is in hours
define('support_upload_file_size' ,1); // Support file upload size less than 1MB
define('asw_s3_mantra_images' ,'/images/mantra_images/'); // S3 mantra images path
define('mantra_images_path' ,'/uploads/mantra_images/'); // mantra images local path
define('support_images_path' ,'/uploads/support_images/'); // support images local path
// ================= API Related Constants ============= //

//=================== DattaId Api =================//
define('dattaid_sso_client' ,'2yi7opdvgmotb7bfy3bfh3mhz1vwr8q6'); //dattapeetham client id
define('dattaid_sso_client_secret_key' ,'1kjqt5o8blffrjiwdrcj2jy2yxpmwuls72jnloe21zsbz27vtrbj7xkcy8no7o14'); //dattapeetham client secret key
define('dattaid_auth_token' ,'TUFOR1U1TVpU16WXpOREJsTmpoaQe3x'); //auth token for curl reuqest accept
define('email_verification_count_per_day','3');
define("verification_email_time_gap",24); //24 hours
define('api_exp_time' ,strtotime('+ 1 year', time())); //api token expiry time
define('dattaid_api_url','https://dev.dattaid.org/apis/');
define('dattaid_login' ,dattaid_api_url.'login'); //dattaid login api
define('dattaid_donors' ,dattaid_api_url.'donors/index'); //dattaid donors list api
define('dattaid_unhidedonors' ,dattaid_api_url.'donors/userUnhideDonors'); //dattaid donors list api
define('dattaid_check_email' ,dattaid_api_url.'profile/checkEmailExists'); //dattaid checking email api
define('dattaid_profile_edit' ,dattaid_api_url.'profile/edit'); //dattaid profile edit
define('dattaid_change_password' ,dattaid_api_url.'changepassword'); //dattaid change password
define('dattaid_donors_view' ,dattaid_api_url.'donors/view'); //dattaid donorview
define('dattaid_donors_edit' ,dattaid_api_url.'donors/edit'); //dattaid donor edit
define('dattaid_donors_create' ,dattaid_api_url.'donors/create'); //dattaid donor create
define('dattaid_donors_hideorunhide' ,dattaid_api_url.'donors/donorHideUnhide'); //dattaid donor create
define('dattaid_donor_delete' ,dattaid_api_url.'donors/delete'); //dattaid donor create
define('dattaid_donor_address_update' ,dattaid_api_url.'donors/addressUpdate'); //dattaid donor address update
define('dattaid_user_address_update' ,dattaid_api_url.'profile/addressUpdate'); //user address donor create
define('dattaid_user_email_bounce_update' ,dattaid_api_url.'profile/updateBounceCoun'); //user email bounce
define('dattaid_user_idproff_update' ,dattaid_api_url.'profile/updateDocument'); //user email bounce
define('dattaid_donor_fulldata' ,dattaid_api_url.'donors/donorsFullData'); //donors data based on user
define('dattaid_donors_sevakarta' ,dattaid_api_url.'donors/sevaKartaDonors'); //Seva karta donors data based on orders
define('dattaid_donors_usercount' ,dattaid_api_url.'donors/userDonorsCount'); //user donors count
define('dattaid_donors_createDefault' ,dattaid_api_url.'donors/createDefault'); //create donor default
define('dattaid_donors_adminlist' ,dattaid_api_url.'donors/donorsAdmin'); //donors admin list
define('dattaid_donors_countries' ,dattaid_api_url.'donors/donorCountries'); //donors countries
define('dattaid_donors_donorByIds' ,dattaid_api_url.'donors/donorsByIds'); //donors countries
define('dattaid_register_check_email' ,dattaid_api_url.'register/checkEmailExists'); //registration email checking
define('dattaid_register_check_username' ,dattaid_api_url.'register/checkUsernameExit'); //registration username checking
define('dattaid_user_register' ,dattaid_api_url.'register'); //user registration
define('dattaid_user_data_diff_site' ,dattaid_api_url.'profile/userFromOtherSite'); //user registration
define('dattaid_user_social_login' ,dattaid_api_url.'sociallogin'); //user socail login
define('dattaid_user_forgotpass' ,dattaid_api_url.'forgotpassword'); //user forgot password
define('dattaid_user_forgotpass_update' ,dattaid_api_url.'forgotpassword/updatePassword'); //user forgot password update
define('dattaid_admin_user_register_prefillId' ,dattaid_api_url.'useradmin/populateUserId'); //user register by admin
define('dattaid_prefillId_update' ,dattaid_api_url.'useradmin/updatePrefillUserId'); //user register by admin
define('dattaid_userregiter_by_admin' ,dattaid_api_url.'useradmin/userRegisterByAdmin'); //user register by admin
define('dattaid_reset_userpass_by_admin' ,dattaid_api_url.'useradmin/resetUserPass'); //user register by admin
define('dattaid_useredit_by_admin' ,dattaid_api_url.'useradmin/useredit'); //user register by admin
define('dattaid_adminuser_registration' ,dattaid_api_url.'useradmin/saveAdminUser'); //adminuser registration
define('dattaid_adminuser_update' ,dattaid_api_url.'useradmin/editAdminUser'); //adminuser updation
define('dattaid_adminuser_username_check' ,dattaid_api_url.'useradmin/adminUserNamecheck'); //adminuser username check
define('dattaid_adminuser_email_check' ,dattaid_api_url.'useradmin/adminUserEmailcheck'); //adminuser email registration
define('dattaid_add_bulk_user' ,dattaid_api_url.'useradmin/addBulkUser'); //adminuser email registration
define('dattaid_update_client_site_settings' ,dattaid_api_url.'updateclientsiteSettings'); //adminuser email registration
define('dattaid_user_forgot_check' ,dattaid_api_url.'forgotpassword/forgotCheck'); //forgot check
define('dattaid_user_details_byamdin' ,dattaid_api_url.'useradmin/getUserDetails'); //get userdetail through admin
define('dattaid_admin_get_userdata_register' ,dattaid_api_url.'useradmin/userFromOtherSite'); //user registration by admin from other site
define('dattaid_forgot_key_details' ,dattaid_api_url.'forgotpassword/getForgotkey'); //get forgot key details
define('dattaid_admin_searchUsers' ,dattaid_api_url.'useradmin/searchUsers'); //add poojas search users
define('dattaid_user_change_pass' ,dattaid_api_url.'changepassword/getUserDetails'); //get user pass hash
define('dattaid_force_changepass' ,dattaid_api_url.'changepassword/forceChangePass'); //force change pass
define('dattaid_checkuser_self_donor' ,dattaid_api_url.'donors/getUserSelfDonors'); //check user self donor
define('dattaid_checkuser_selfdonor_bydonorid' ,dattaid_api_url.'donors/checkselfDonorExits'); //check user self
define('dattaid_getuser_selfdonor' ,dattaid_api_url.'donors/getUserSelfDonorData'); //get user self donor data
define('dattaid_logout_user' ,dattaid_api_url.'login/logout'); //user logout
//=================== DattaId Api =================//

/*
|--------------------------------------------------------------------------
| File and Directory Modes
|--------------------------------------------------------------------------
|
| These prefs are used when checking and setting modes when working
| with the file system.  The defaults are fine on servers with proper
| security, but you may wish (or even need) to change the values in
| certain environments (Apache running a separate process for each
| user, PHP under CGI with Apache suEXEC, etc.).  Octal values should
| always be used to set the mode correctly.
|
*/

defined('FILE_READ_MODE')  OR define('FILE_READ_MODE', 0644);
defined('FILE_WRITE_MODE') OR define('FILE_WRITE_MODE', 0666);
defined('DIR_READ_MODE')   OR define('DIR_READ_MODE', 0755);
defined('DIR_WRITE_MODE')  OR define('DIR_WRITE_MODE', 0755);

/*
|--------------------------------------------------------------------------
| File Stream Modes
|--------------------------------------------------------------------------
|
| These modes are used when working with fopen()/popen()
|
*/

defined('FOPEN_READ')                           OR define('FOPEN_READ', 'rb');
defined('FOPEN_READ_WRITE')                     OR define('FOPEN_READ_WRITE', 'r+b');
defined('FOPEN_WRITE_CREATE_DESTRUCTIVE')       OR define('FOPEN_WRITE_CREATE_DESTRUCTIVE', 'wb'); // truncates existing file data, use with care
defined('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE')  OR define('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE', 'w+b'); // truncates existing file data, use with care
defined('FOPEN_WRITE_CREATE')                   OR define('FOPEN_WRITE_CREATE', 'ab');
defined('FOPEN_READ_WRITE_CREATE')              OR define('FOPEN_READ_WRITE_CREATE', 'a+b');
defined('FOPEN_WRITE_CREATE_STRICT')            OR define('FOPEN_WRITE_CREATE_STRICT', 'xb');
defined('FOPEN_READ_WRITE_CREATE_STRICT')       OR define('FOPEN_READ_WRITE_CREATE_STRICT', 'x+b');

/*
|--------------------------------------------------------------------------
| Exit Status Codes
|--------------------------------------------------------------------------
|
| Used to indicate the conditions under which the script is exit()ing.
| While there is no universal standard for error codes, there are some
| broad conventions.  Three such conventions are mentioned below, for
| those who wish to make use of them.  The CodeIgniter defaults were
| chosen for the least overlap with these conventions, while still
| leaving room for others to be defined in future versions and user
| applications.
|
| The three main conventions used for determining exit status codes
| are as follows:
|
|    Standard C/C++ Library (stdlibc):
|       http://www.gnu.org/software/libc/manual/html_node/Exit-Status.html
|       (This link also contains other GNU-specific conventions)
|    BSD sysexits.h:
|       http://www.gsp.com/cgi-bin/man.cgi?section=3&topic=sysexits
|    Bash scripting:
|       http://tldp.org/LDP/abs/html/exitcodes.html
|
*/

defined('EXIT_SUCCESS')        OR define('EXIT_SUCCESS', 0); // no errors
defined('EXIT_ERROR')          OR define('EXIT_ERROR', 1); // generic error
defined('EXIT_CONFIG')         OR define('EXIT_CONFIG', 3); // configuration error
defined('EXIT_UNKNOWN_FILE')   OR define('EXIT_UNKNOWN_FILE', 4); // file not found
defined('EXIT_UNKNOWN_CLASS')  OR define('EXIT_UNKNOWN_CLASS', 5); // unknown class
defined('EXIT_UNKNOWN_METHOD') OR define('EXIT_UNKNOWN_METHOD', 6); // unknown class member
defined('EXIT_USER_INPUT')     OR define('EXIT_USER_INPUT', 7); // invalid user input
defined('EXIT_DATABASE')       OR define('EXIT_DATABASE', 8); // database error
defined('EXIT__AUTO_MIN')      OR define('EXIT__AUTO_MIN', 9); // lowest automatically-assigned error code
defined('EXIT__AUTO_MAX')      OR define('EXIT__AUTO_MAX', 125); // highest automatically-assigned error code
define('curl_auth_token','TUFOR1U1TVpU16WXpOREJsTmpoaQe3x');

?>